#ifndef __KP_TOPLEVEL_H
#define __KP_TOPLEVEL_H

#include <kmainwindow.h>

class KPMainWidget;
class KProgress;
class QPopupMenu;

class KPTopLevel : public KMainWindow
{
    Q_OBJECT
public:
    KPTopLevel(const char *name=0);
    void load(const QString &str);
public slots:
    void slotMessage(const QString &msg);
    void slotProgress(int val);
    void slotZoom(const QString &str);
    void slotSaveEnabled(bool en);
    void slotCloseEnabled(bool en);
    void slotZoomInEnabled(bool en);
    void slotZoomOutEnabled(bool en);
protected:
    KPMainWidget *mainWidget;
    QPopupMenu *fileMnu, *zoomMnu;
    KProgress *progress;

    enum StatusID{Progress=1, Zoom, Message};
    enum MenuID{FileOpen=1, SaveSingle, SaveAll, SaveHeader, SavePoints,
        FileClose, ZoomIn, ZoomOut};
};

#endif
