/*
* viewer.h -- Declaration of class KImageViewer.
* Generated by newclass on Wed Oct 15 11:37:16 EST 1997.
*/
#ifndef SSK_VIEWER_H
#define SSK_VIEWER_H

#include <kmainwindow.h>
#include <kaccel.h>
#include <qwmatrix.h>
#include <kurl.h>

class QMenuData;
class QPopupMenu;
class QMouseEvent;
class QString;
class QTimer;
class QAccel;

class KDNDDropZone;
class KFiltMenuFactory;
class KConfigGroup;
class KImageCanvas;
class KImageFilter;
class KLocale;
class KMenuBar;
class KStatusBar;
class KIOJob;
class QDropEvent;

class ImgListDlg;
class KAccelMenuWatch;


/**
* Top-level window
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: viewer.h,v 1.20 2000/09/03 01:34:56 waba Exp $
*/
class KImageViewer : public KMainWindow
{
	Q_OBJECT
public:
	/**
	* KImageViewer Constructor
	*/
	KImageViewer();

	/**
	* KImageViewer Destructor
	*/
	virtual ~KImageViewer();

	/**
	* This should be called _before_ show!
	*/
	void setFilterMenu( KFiltMenuFactory *filters );

	/**
	* Release the current cut buffer, if any.
	*/
	void freeCutBuffer();

signals:
	void wantHelp( const QString & tag );

	/**
	* User has requested a new viewer object.
	*/
	void wantNewViewer();

	/**
	* Viewer has lost the will to live.
	*/
	void wantToDie( KImageViewer * );
	
	/**
	* A new image has been placed in the clipboard.
	*/
	void newCutBuffer( QPixmap *buffer );

	/**
	* The accelerator object has been reconfigured.
	*/
	void accelChanged();

public slots:
	// File operations
	/** */
	void load();
	/** */
	void saveAs();

	/** */
	void quitApp();

	// Size
	/** */
	void zoomIn10();
	/** */
	void zoomOut10();
	/** */
	void zoomIn200();
	/** */
	void zoomOut50();
	/** */
	void zoomCustom();

	// Desktop
	void tile();
	void max();
	void maxpect();

	// Transformation
	/** */
	void rotateClock();
	/** */
	void rotateAntiClock();
	/** */
	void flipVertical();
	/** */
	void flipHorizontal();

	void reset();

	// Information
	/** */
	void help();
	void helpHow();
	void helpWhat();

	/** */
	void about();

	/** */
	void prefs();

	/**
	* Loads a file from a URL.
	*/
	void loadURL( const KURL &url );

	/**
	* Queues into the view list.
	*/
	void appendURL( const KURL &url, bool show = false );

	/**
	* Toggle full screen mode.
	*/
	void fullScreen();

	/**
	* Ask for print settings and print the image.
	*/
	void printImage();

	void cut();
	void copy();
	void paste();

	void contextPress( const QPoint& );

	void updateAccel();

protected slots:
	void newViewer();
	void closeViewer();

private slots:
	void invokeFilter( KImageFilter *filter );

	void setStatus( const QString & status );
	void message( const QString & message );
	void setProgress( int pct );

	void toggleImageList();

	void setSize();

protected:

	virtual void closeEvent( QCloseEvent * );

	virtual void saveProperties( KConfig * ) const;
	virtual void restoreProperties( KConfig * );

	virtual void saveOptions( KConfig * ) const;
	virtual void restoreOptions( KConfig * );

  virtual void dragEnterEvent(QDragEnterEvent* event);
	virtual void dropEvent(QDropEvent *e);

private:
	/** image canvas */
	KImageCanvas	*_canvas;
	bool		_imageLoaded;
	

	/**
	* Configurable keybinding object
	*/
	KAccel		*_kaccel;
	QAccel		*_paccel;
	KAccelMenuWatch *_watcher;

	KMenuBar	*_menubar;
	KStatusBar	*_statusbar;
	QPopupMenu	*_contextMenu;

	QPopupMenu	*_file;
	QPopupMenu	*_edit;
	QPopupMenu	*_zoom;
	QPopupMenu	*_transform;
	QPopupMenu	*_desktop;
	QPopupMenu	*_aggreg;
	QPopupMenu	*_help;

	int		_barFilterID;
	int		_popFilterID;
	
	// Net transfer stuff

	enum TransferDir {
		Get,
		Put
	};

	KIOJob		*_iojob;
	QString		_transSrc;
	QString		_transDest;
	TransferDir	_transDir;

	KFiltMenuFactory *_menuFact;

	QString 	*_pctBuffer;
	int		_lastPct;

	QTimer		*_msgTimer;

	ImgListDlg	*_imageList;

	QPoint		_posSave;
	QSize		_sizeSave;
	QWMatrix	_mat;

	int		_zoomFactor;

	enum LoadMode { ResizeWindow, ResizeImage, ResizeNone };
	LoadMode	_loadMode;

private:
	void makeAccel();
	void makeRootMenu(QPopupMenu *);
	void makeRootMenu(KMenuBar * );
	void makePopupMenus();

	/**
	* Resize the window to fit the image.
	*/
	void rzWinToImg();

	/**
	* Do-it-all function that operates on _kaccel and the current
	* menu set in the _watcher:
	*
	* 1. Inserts an item into the menu with desc "text", which calls
	* receiver/method.
	*
	* 2. Inserts accel "action" with desc "text" into _kaccel.
	* 
	* 3. Connects the keybinding, if any, to the menu item and the action.
	*/
	int conn( const QString & text, const char *action,
			QObject *receiver, const char *method, uint key = 0 );

	/**
	* Same as above, but for standard accels.
	*/
	int conn( const QString & text, KStdAccel::StdAccel,
			QObject *receiver, const char *method );

	void loadFile( const QString & file, const KURL &url = KURL() );

};

#endif // SSK_VIEWER_H
