#ifndef __IMAGELIST_H
#define __IMAGELIST_H

#include <kmainwindow.h>
#include "imagewindow.h"
class KIFDndListBox;
class QListBoxItem;

class KIFImageList : public KMainWindow
{
    Q_OBJECT
public:
    KIFImageList(const char *name=0);
    ~KIFImageList();
    KIFImageWindow *window(){return(imageWindow);}
public slots:
    void slotToggleFileList();
    void slotThumbnails();
    // these can be either urls or local file paths
    void slotAddURL(const QString &urlStr);
    void slotAddAndSetURL(const QString &urlStr);
    void slotURLSelected(QListBoxItem *i);
    void slotSetTopItem();
protected slots:
    void slotOpen();
    void slotSave();
    void slotSaveAs();
    void slotPrint();
    void slotCopy();
    void slotPaste();
    void slotScale();
    void slotScaleIn();
    void slotScaleOut();
    void slotDouble();
    void slotShrink();
    void slotBack();
    void slotForward();
    void slotReload();
    void slotBright();
    void slotDim();
    void slotMirrorHoriz();
    void slotMirrorVert();
    void slotInvert();
    void slotIncContrast();
    void slotDecContrast();
    void slotCrop();
    void slotImageColor();
    void slotSingleColor();
    void slotGenerateHtml();
    void slotGrab();
    void slotPlayAni();
    void slotDropFinished();
    void slotHide();
    void slotShow();
    void slotQuit();
protected:
    void closeEvent(QCloseEvent *ev);
    int findURLIndex(const QString &url);
    void loadColorPlugin();

    void *(*singleColorDlg)();
    void *(*imageColorDlg)();
    
    KIFDndListBox *fileList;
    KIFImageWindow *imageWindow;
    bool wasVisible, dlregistered;
};

#endif
