/**
 * This file is part of the html renderer for KDE.
 *
 * Copyright (C) 2000 Lars Knoll (knoll@kde.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * $Id: render_body.cpp,v 1.5 2000/07/20 13:19:33 knoll Exp $
 */
#include "render_body.h"

#include <qpainter.h>

#include <kdebug.h>

using namespace khtml;

RenderBody::RenderBody()
    : RenderFlow()
{
}

RenderBody::~RenderBody()
{
}

void RenderBody::printBoxDecorations(QPainter *p,int, int _y,
				       int, int _h, int _tx, int _ty)
{
    //kdDebug( 6040 ) << renderName() << "::printDecorations()" << endl;

    QColor c;
    if( parent()->style()->backgroundColor().isValid() )
	c =  m_style->backgroundColor();
    CachedImage *bg = 0;
    if( parent() ->backgroundImage() )
	bg = m_bgImage;
    
    int w = width();
    int h = height() + borderTopExtra() + borderBottomExtra();	
    _ty -= borderTopExtra();

    int my = QMAX(_ty,_y);
    int mh;
    if (_ty<_y)
    	mh=QMAX(0,h-(_y-_ty));
    else
    	mh = QMIN(_h,h);

    printBackground(p, c, bg, my, mh, _tx, _ty, w, h);

    if(m_style->hasBorder())
	printBorder( p, _tx, _ty, w, h );

}

void RenderBody::repaint()
{
    RenderObject *cb = containingBlock();
    if(cb != this)
	cb->repaint();
}
