#ifndef MAIN_H
#define MAIN_H
#include <qiomanager.h>
#include <dispatcher.h>
#include <qmessagebox.h>
#include <kapp.h>
#include <qframe.h>
#include <kmainwindow.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kstdaction.h>
#include <kled.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <artsflow.h>
#include <soundserver.h>
#include <qobject.h>
#include "flowsystem.h"

class VScale;

class FFTScopeView : public QWidget {
	Q_OBJECT
protected:
	Arts::StereoFFTScope scopefx;
	Arts::SimpleSoundServer server;
	long effectID;

	vector<float> *scopeData;
	vector<float> scopeDraw;
	vector<VScale *> scopeScales;

	void closeEvent(QCloseEvent *e);
public:
	void updateScopeData();
	FFTScopeView(Arts::SimpleSoundServer server);
	~FFTScopeView();

public slots:
	void updateScope();
signals:
	void closed();
};

class VControl : public QFrame {
	Q_OBJECT
protected:
	class VScale *left, *right;
	class FFTScopeView *scopeView;
	class Gui_AUDIO_MANAGER *audioManager;
	Arts::StereoVolumeControl svc;
	Arts::SimpleSoundServer server;
	long effectID;

public:
	VControl(QWidget *parent);
	~VControl();

public slots:
	void updateScales();
	void setVolume(int vol);
	void showScopeView();
	void removeScopeView();
	void showAudioManager();
	void removeAudioManager();
};

#endif /* MAIN_H */
