/*
   Copyright (c) 2000 Stefan Schimanski <1Stein@gmx.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ID3_H_INCLUDED
#define ID3_H_INCLUDED

#include <qobject.h>
#include <kurl.h>
#include <qtimer.h>
#include <qlist.h>


class ID3Tag
{
 public:
    ID3Tag( void *user=0 ) { _user=user; };

    QString songName() const { return QString::fromLatin1( _id3tag.songname ); };
    QString artist() const { return QString::fromLatin1( _id3tag.artist ); };
    QString album() const { return QString::fromLatin1( _id3tag.album ); };    
    QString note() const { return QString::fromLatin1( _id3tag.note ); };

    bool open( const KURL &url );
    void *user() { return _user; };

 private:
    struct {
	char		magic[3];
	char		songname[30];
	char		artist[30];
	char		album[30];
	char		year[4];
	char		note[30];
	unsigned char	style;
    } _id3tag;

    void *_user;
};


class ID3Reader : public QObject
{
 Q_OBJECT
 public:
    ID3Reader( QObject *parent=0, const char *name=0 );
    virtual ~ID3Reader();

    void queue( const KURL &url, void *user );
    void dequeue( void *user );
    void stop();

 signals:
    void readID3( const QList<ID3Tag> &tags );

 private slots:
    void timeout();

 private:

    struct ID3Job
    {
	KURL url;
	void *user;
    };

    QList<ID3Job> _queue;
    QTimer _timer;
};


#endif
