/*
   Copyright (c) 2000 Stefan Schimanski <1Stein@gmx.de>
                 1999-2000 Christian Esken (esken@kde.org)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <kapp.h>
#include <kglobal.h>
#include <kimageio.h>
#include <dcopclient.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <qiomanager.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include <stdlib.h>
#include <time.h>

#include "main.h"
#include "kaiman.h"

static const char *description=I18N_NOOP("KDE 2.0 Media Player");

static const KCmdLineOptions options[] =
{
        { "skin <skin>", I18N_NOOP("Name of the Skin"), 0 },
        { "r", 0, 0 },
        { "rew", I18N_NOOP("Skip backwards in playlist"), 0 },
        { "p", 0, 0 },
        { "play", I18N_NOOP("Start playing current playlist"), 0 },
        { "u", 0, 0 },
        { "pause", I18N_NOOP("Pause current song"), 0 },
        { "s", 0, 0 },
        { "stop", I18N_NOOP("Stop current song"), 0 },
        { "f", 0, 0 },
        { "fwd", I18N_NOOP("Skip forward in playlist"), 0 },
        { "e", 0, 0 },
        { "enqueue", I18N_NOOP("Don't clear the playlist"), 0 },
        { "m", 0, 0 },
        { "show-main-window", I18N_NOOP("Show the main window"), 0 },
        { "+file(s)", I18N_NOOP("Files to open"), 0 },
        { 0, 0, 0}
};


KaimanApp::KaimanApp()
    : KUniqueApplication(), m_kaiman( 0 )
{
    KImageIO::registerFormats();
    srand(time(0L));
}


KaimanApp::~KaimanApp()
{
    delete m_kaiman;
}


int KaimanApp::newInstance()
{
    // parse command line
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    if ( !m_kaiman ) {
        // load style
        QCString skin;
        if ( args->isSet("skin") )
            skin = args->getOption("skin");

        m_kaiman = new Kaiman( skin );
        if ( isRestored() && KMainWindow::canBeRestored(0) )
            m_kaiman->restore(0, FALSE);
        else
            m_kaiman->show();
    }

    // load files
    if ( args->count()>0 ) {
        // clear list by default
        if ( !args->isSet("enqueue") )
            m_kaiman->clear();

        // add files to list
        for( int i=0; i<args->count(); i++ )
        {
            KURL url = args->url(i);
            if ( !url.isMalformed() )
                m_kaiman->addURL( url );
        }
    }

    // control kaiman
    if ( args->isSet("play") ) m_kaiman->play();
    if ( args->isSet("stop") ) m_kaiman->stop();
    if ( args->isSet("fwd") ) m_kaiman->next();
    if ( args->isSet("rew") ) m_kaiman->prev();

    // reshow window
    if ( args->isSet("show-main-window") )
        m_kaiman->raise();

    return 0;
}


int main(int argc, char **argv)
{
  KAboutData aboutData( "kaiman", I18N_NOOP("Kaiman"),
                        "0.3.2", description, KAboutData::License_GPL, "(c) 2000 Stefan Schimanski, Christian Esken");
  aboutData.addAuthor("Stefan Schimanski", 0, "1Stein@gmx.de");
  aboutData.addAuthor("Christian Esken", I18N_NOOP("First implementation, style engine"), "esken@kde.org");
  aboutData.addAuthor("Stefan Westerfeld", I18N_NOOP("aRts"), "stefan@space.twc.de");
  aboutData.addAuthor("Martin Vogt", I18N_NOOP("Audio/Video codecs"), "mvogt@rhrk.uni-kl.de");
  aboutData.addAuthor("Charles Samuels", I18N_NOOP("Playlist loading/saving"), "charles@kde.org");

  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options );
  KUniqueApplication::addCmdLineOptions();

  if (!KaimanApp::start())
      return 0;

  KaimanApp app;
  return app.exec();
}
