/*
   Copyright (c) 2000 Stefan Schimanski <1Stein@gmx.de>
                 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef PLAYLIST_H_INCLUDED
#define PLAYLIST_H_INCLUDED

#include <kmainwindow.h>
#include <kurl.h>


class MediaFile
{
 public:
    MediaFile() { _length=0; _pos=0; };
    virtual ~MediaFile() {};

    void setURL( const KURL &url ) { _url = url; };
    KURL url() const { return _url; };

    void setTitle( const QString &title ) { _title = title; };
    QString title() const { 
        if ( _title.length()>0 )
            return _title;
        else
            return _url.fileName();
    };

    void setLength( const long length ) { _length = length; };
    long length() const { return _length; };

    void setPos( const int pos ) { _pos = pos; };
    int pos() const { return _pos; };

 private:
    KURL _url;   
    QString _title;
    long _length;
    int _pos;
};


class MediaManagerBase : public KMainWindow
{
 Q_OBJECT
public:  
    MediaManagerBase( const char *name ) : KMainWindow( 0, name, WType_TopLevel ) {};

    virtual MediaFile *next( bool reverse=false, bool loop=false ) = 0;
    virtual MediaFile *start( bool reverse=false ) = 0;
    virtual void reset() = 0;
    virtual MediaFile *active() = 0;
    virtual MediaFile *shuffle() = 0;
    virtual int count() = 0;
    virtual int position() = 0;
    
public slots:
    virtual void clear() = 0;
    virtual void addPlaylist( const KURL &url, bool update=true ) = 0;
    virtual void addURL( const KURL &url, bool update=true ) = 0;

signals:
    void stop();
    void play( MediaFile *file );
};



#endif
