/*
   Copyright (c) 1999-2000 Stefan Schimanski <1Stein@gmx.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <klocale.h>
#include <qlayout.h>
#include <qlabel.h>
#include <klistbox.h>
#include <qdir.h>
#include <qfileinfo.h>
#include <kglobal.h>
#include <kdebug.h>
#include <kstddirs.h>

#include "pref.h"


KaimanPrefDlg::KaimanPrefDlg( QWidget *parent, const char *name, bool modal )
    : KDialogBase( parent, name, modal, i18n("Kaiman Preferences") )
{
    QWidget *skinPage = createSkinPage();
    setMainWidget( skinPage );
}


KaimanPrefDlg::~KaimanPrefDlg()
{
}


void KaimanPrefDlg::setSkin( QString skin )
{
    _skinList->setCurrentItem( _skinList->findItem( skin ) );
}


QString KaimanPrefDlg::skin()
{
    return _skinList->currentText();
}


QWidget *KaimanPrefDlg::createSkinPage()
{
    QWidget *page = new QWidget( this );

    // create widgets
    QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );
    QLabel *label = new QLabel( i18n("Kaiman Skins"), page, "label" );
    topLayout->addWidget( label );

    _skinList = new KListBox( page, "skinList" );
    topLayout->addWidget( _skinList, 1 );

    // fill with available skins
    KGlobal::dirs()->addResourceType("Skins", KStandardDirs::kde_default("data") + "kaiman/Skins");
    QStringList list = KGlobal::dirs()->resourceDirs("Skins");
    for (QStringList::ConstIterator it = list.begin(); it != list.end(); it++)
        readSkinDir(*it);

    return page;
}


void KaimanPrefDlg::readSkinDir( const QString &dir )
{
    kdDebug() << "readSkinDir " << dir << endl;

    QDir directory( dir );
    if (!directory.exists())
    return;

    const QFileInfoList *list = directory.entryInfoList();
    QFileInfoListIterator it(*list);

    while ( it.current() ) {
        kdDebug() << it.current()->absFilePath() << endl;
        QFileInfo skindata( it.current()->absFilePath()+"/skindata" );

        if ( skindata.exists() ) {
            _skinList->insertItem( it.current()->baseName() );
        }

        ++it;
    }
}

#include "pref.moc"
