/*
  reads toc from cdrom (system dependend)
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __CDROMTOC_H
#define __CDROMTOC_H

#include <iostream.h>

extern "C" {
#include <stdio.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
}

struct TocEntry {
  int minute;
  int second;
  int frame;
};


class CDRomToc {

  TocEntry tocEntries[100];
  int maxEntries;
  int startByte;
  int endByte;

 public:
  CDRomToc();
  virtual ~CDRomToc();
  int open(const char* device);
  int getTocEntries();
  TocEntry* getTocEntry(int entry);
  void insertTocEntry(int minute,int second,int frame);
  int getNextTocEntryPos(int minute,int second,int frame);
  int isInRange(int minute,int second,int frame);
  int isElement(int minute,int second,int frame);

  int getEndSecond();

  void print();

 private:
  // platform specific calls.
  int getStartEnd(int fd,int& start, int& end);
  int readToc(int fd,int num,int& min,int& sec, int& frame);
  int readLeadOut(int fd,int& min,int& sec, int& frame);




  int calculateRange();

};

#endif
