/*
  abstraction for threads
  Copyright (C) 2000 Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __ABS_THREAD_H
#define __ABS_THREAD_H

/**
   This passed alle pthread_xxx calls to this interface, thus
   it can be easier replaced with other thread "layers"

   All posix pthread calls are conveterd to abs_thread.
*/

extern "C" {
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <errno.h>
#include <string.h>
}

#include <iostream.h>


#define _ABS_BUSY EBUSY

// definitions for direct pthread support

typedef pthread_mutex_t abs_thread_mutex_t;
typedef pthread_cond_t abs_thread_cond_t;
typedef pthread_t abs_thread_t;



#define abs_thread_cond_init(cond) pthread_cond_init(cond,NULL)
#define abs_thread_cond_destroy(cond) pthread_cond_destroy(cond)
#define abs_thread_cond_signal(cond) pthread_cond_signal(cond)
#define abs_thread_cond_wait(cond,mutex) pthread_cond_wait(cond,mutex)

// CREATE / JOIN THREAD

#define abs_thread_create(thread,func,arg) pthread_create(thread,NULL,func,arg)
#define abs_thread_join(th,thread_return) pthread_join(th,thread_return)

// MUTEX FUNCTIONS

#define abs_thread_mutex_lock(mutex) pthread_mutex_lock(mutex)
#define abs_thread_mutex_trylock(mutex) pthread_mutex_trylock(mutex)
#define abs_thread_mutex_unlock(mutex) pthread_mutex_unlock(mutex)
#define abs_thread_mutex_init(mutex) pthread_mutex_init(mutex,NULL)
#define abs_thread_mutex_destroy(mutex) pthread_mutex_destroy(mutex)




#endif


