/*
  puts the yuv images onto a surface
  Copyright (C) 2000  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "renderMachine.h"




RenderMachine::RenderMachine() {

#ifndef SDL_WRAPPER 
  surface=new X11Surface();
#endif
#ifdef SDL_WRAPPER 
  surface=new SDLSurface();
#endif


  imageMode= _IMAGE_NONE;
  imageSize= _SIZE_NONE;
  pictureArray=NULL;

  startTime=new TimeStamp();
  endTime=new TimeStamp();


}


RenderMachine::~RenderMachine() {


  closeWindow();
  delete surface;

  delete startTime;
  delete endTime;

}






void RenderMachine::waitRestTime() {
  endTime->gettimeofday();
  startTime->minus(endTime,endTime);
  endTime->waitForIt();

}




int RenderMachine::openWindow(int width, 
			      int height,const char *title) {

  int lok;
  if (surface->isOpen()) {
    // can we use the same window?
    if ((width == surface->getWidth()) && 
	(height == surface->getHeight())) {
      return true;
    }
    closeWindow();
  }  
  lok=surface->open(width,height,title);
  pictureArray=new PictureArray(surface->getWidth(),
				surface->getHeight());

  if(lok==false) {
    switchToMode(_IMAGE_NONE,_SIZE_NONE);
    return false;
  }
  imageMode= _IMAGE_NONE;
  imageSize= _SIZE_NONE;
  switchToMode(_IMAGE_DESK,_SIZE_NORMAL);

  return true;
}


void RenderMachine::closeWindow() {
  
  if (surface->isOpen()==false) {
    return;
  }
  if (pictureArray != NULL) {
    delete pictureArray;
    pictureArray=NULL;
  }
  surface->close();
}

/**
   important method. This is our only way to switch from
   fullscreen back to the desktop screen.
   This method is called if the video end (normal or by user request)
   We dont have a callback, thus after the image stops, we would
   never get events.
*/
void RenderMachine::flushWindow() {

  // we always switch back to desk mode.
  if (imageMode == _IMAGE_FULL) {
    switchToMode(_IMAGE_DESK,_SIZE_NORMAL);
  }


}




void RenderMachine::putImage(YUVPicture* pic,
			     TimeStamp* waitTime,
			     TimeStamp* ) {
  if (pic == NULL) {
    cout << "pic is null"<<endl;
    return;
  }
  int nextMode=imageMode;
  int nextSize=imageSize;
  if (surface->checkEvent(&nextMode,&nextSize) == true) {
    switchToMode(nextMode,nextSize);
  }
  startTime->gettimeofday();
  startTime->addOffset(waitTime);

  // need dither?
  surface->dither(pic);
 
  surface->putImage(pic);
  waitRestTime();
}


int RenderMachine::switchToMode(int mode,int size) {
  int lClose=false;

  if (imageMode != mode) {
    lClose=true;
  }
  if (imageSize != size) {
    lClose=true;
  }
  if (lClose==true) {
    surface->closeImage();
  }

  imageMode=mode;
  imageSize=size;
  if (lClose == true) {
    switch (imageMode) {
    case _IMAGE_DESK:
    case _IMAGE_FULL: 
      surface->openImage(imageSize,imageMode);
      break;
    default:
      cout << "no imageMode, no open, that's life"<<endl;
    }
  }
  return true;
}



PictureArray* RenderMachine::lockPictureArray() {
  return pictureArray;
}


void RenderMachine::unlockPictureArray(PictureArray* pictureArray) {
  // chance to switch mode

  
  // put picture out
  if ( (imageMode != _IMAGE_NONE) && 
       (imageSize != _SIZE_NONE) ) {
    YUVPicture* pic=pictureArray->getYUVPictureCallback();
    if (pic != NULL) {
      TimeStamp* waitTime=pic->getWaitTime();
      TimeStamp* earlyTime=pic->getEarlyTime();
      putImage(pic,waitTime,earlyTime);
    }
  } else {
    cout << "no mode/size selected"<<endl;
  }
}


void RenderMachine::config(const char* key, 
			   const char* value,void* user_data) {
  if (strcmp(key,"getDepth")==0) {
    int* val=(int*)user_data;
    *val=surface->getDepth();
  }
  surface->config(key,value,user_data);
}



