/*
  SDL surface output
  Copyright (C) 2000  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "imageDeskSDL.h"

#ifdef SDL_WRAPPER


ImageDeskSDL::ImageDeskSDL(SDL_Surface* surface,SDL_Rect* rect) {

  this->surface=surface;
  this->rect=rect;

  lSupport=true;
  image=NULL;
}


ImageDeskSDL::~ImageDeskSDL() {
  closeImage();
  cout << "SDL destry needed"<<endl;
}



int ImageDeskSDL::support() {
  return lSupport;
}



int ImageDeskSDL::openImage(int ditherSize) {

  /* Create a YV12 image (Y + V + U) */
  cout << "CreateYUVOverlay -s"<<endl;
  image = SDL_CreateYUVOverlay(rect->w,
			       rect->h,
			       SDL_YV12_OVERLAY, 
			       surface);
  if (image == NULL) {
    cout << "error creating image"<<endl;
    exit(0);
  }
  cout << "CreateYUVOverlay -e"<<endl;
  return true;
}


int ImageDeskSDL::closeImage() {
  if (image != NULL) {
    cout << "FreeYUVOverlay -s"<<endl;
    SDL_FreeYUVOverlay(image);
    cout << "FreeYUVOverlay -e"<<endl;
  }
  return true;
}



void ImageDeskSDL::ditherImage(YUVPicture* pic) {

  int w=pic->getWidth();
  int h=pic->getHeight();
  int size=w*h+(w*h)/2;
  SDL_LockYUVOverlay(image);
  memcpy(image->pixels,pic->getYUVPtr(),size);
  SDL_UnlockYUVOverlay(image);
 
}


void ImageDeskSDL::putImage() {
  SDL_DisplayYUVOverlay(image,rect);

}

#endif

