/*
  surface wrapper for SDL
  Copyright (C) 2000  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include "sdlSurface.h"


#ifdef SDL_WRAPPER


SDLSurface::SDLSurface() {
  if (SDL_Init(SDL_INIT_VIDEO) < 0 ) {
    fprintf(stderr, "Warning: Couldn't init SDL video: %s\n",
	    SDL_GetError());
    fprintf(stderr, "Will ignore video stream\n");
    exit(0);
  }
  cout << "****************** SDL VIDEO System **********"<<endl;
  /* Get the "native" video mode */
  video_info=SDL_GetVideoInfo();
  video_bpp=video_info->vfmt->BitsPerPixel;
  imageMode=_IMAGE_NONE;
  imageSize=_SIZE_NONE;

  imageCurrent=NULL;
  lOpen=false;
}


SDLSurface::~SDLSurface() {
}


int SDLSurface::isOpen() {
  return lOpen;
}


int SDLSurface::open(int width, int height,const char *title) {
  Uint32 video_flags;
  cout << "SDL openImage"<<endl;
  int video_bpp=video_info->vfmt->BitsPerPixel;
  video_flags = SDL_SWSURFACE;
  video_flags |= SDL_ASYNCBLIT;
  //video_flags |= SDL_RESIZABLE;
  cout << "SetVideoMode -s"<<endl;
  surface = SDL_SetVideoMode(width, height, video_bpp, video_flags);
 
  rect.x = 0;
  rect.y = 0;
  rect.w = width;
  rect.h = height;


  // now create image types
  imageDeskSDL=new ImageDeskSDL(surface,&rect);


  return true;
}


int SDLSurface::close() {
  if (isOpen()==false) {
    cout << "WindowOut::closeWindow already closed"<<endl;
    return true;
  }
  // what to do here?
  return true;
}


int SDLSurface::getHeight() {
  return rect.h;
}


int SDLSurface::getWidth() {
  return rect.w;
}


int SDLSurface::getDepth() {
  return video_bpp;
}


int SDLSurface::openImage(int imageSize,int imageMode) {
  if (this->imageMode != _IMAGE_NONE) {
    cout << "bad open error X11Surface::openImage"<<endl;
    exit(0);
  }
  cout << "************* openImage SDL"<<endl;
  this->imageMode=imageMode;
  imageCurrent=NULL;
  if (imageMode == _IMAGE_DESK) {
    if (imageDeskSDL->support()) {
      imageCurrent=imageDeskSDL;
    }
  }
  if (imageMode == _IMAGE_FULL) {
    // SDL?
  }
  if (imageCurrent != NULL) {
    imageCurrent->openImage(imageSize);
  }
  return (imageCurrent != NULL);
}


int SDLSurface::closeImage() {
  if (imageMode != _IMAGE_NONE) {
    closeImage();
    imageMode=_IMAGE_NONE;
  }
  return true;
}


int SDLSurface::dither(YUVPicture* pic) {
  if (imageCurrent != NULL) {
    imageCurrent->ditherImage(pic);
    imageCurrent->putImage();
  }
  return true;
}


#endif
