/*
  standard and shared mem  X11 images 
  Copyright (C) 2000  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "imageDeskX11.h"


static int lXerror;

static int dummy(Display* , XErrorEvent*) {
  lXerror=true;
  return true;
}



ImageDeskX11::ImageDeskX11(XWindow* xWindow) {
  lSupport=true;
  videoaccesstype=VIDEO_XI_NONE;
  this->xWindow=xWindow;
  virtualscreen=NULL;
  ximage=NULL;
  ditherSize=_SIZE_NONE;
  ditherWrapper=new DitherWrapper(xWindow->depth,
				  xWindow->redMask,
				  xWindow->greenMask,
				  xWindow->blueMask,
				  xWindow->pixel);

#ifdef X11_SHARED_MEM
  shmseginfo=NULL;
#endif

}


ImageDeskX11::~ImageDeskX11() {
  destroyImage();
  delete ditherWrapper;
}


int ImageDeskX11::support() {
  return lSupport;
}


int ImageDeskX11::openImage(int ditherSize) {

  closeImage();
  this->ditherSize = ditherSize;
  int err;

  if ((err=createImage(VIDEO_XI_SHMSTD,ditherSize)) != ERR_XI_OK) {
    printf("\nX initialisation error:\n *** %s\n",ERR_XI_STR[err]);
    printf("check ipcs and delete resources with ipcrm\n");
    if ((err=createImage(VIDEO_XI_STANDARD,ditherSize)) != ERR_XI_OK) {
      printf("\nX initialisation error:\n *** %s\n",ERR_XI_STR[err]);
      videoaccesstype=VIDEO_XI_NONE;
    } else {
      lSupport=true;
    }
  } else {
    lSupport=true;
  }
  switch(videoaccesstype)  {
    case VIDEO_XI_STANDARD:
      printf("  # using conventional Xlib calls.\n\n");
      break;
    case VIDEO_XI_SHMSTD:
      printf("  # Using Xlib shared memory extension %d.%d\n\n",
	     XShmMajor,XShmMinor);
      break;
  default:
    cout << "could not create image->no video output possible"<<endl;

  }  


  if (lSupport==true) {
    return true;
  }
  return false;
}


int ImageDeskX11::closeImage() {
  destroyImage();

  return true;
}


void ImageDeskX11::ditherImage(YUVPicture* pic) {
  ditherWrapper->doDither(pic,xWindow->depth,ditherSize,
			  virtualscreen,0);
}


void ImageDeskX11::putImage(){
  int height=xWindow->height;
  int width=xWindow->width;

  if (ditherSize==_SIZE_DOUBLE) {
    height=2*height;
    width=2*width;
  }
  
#ifdef X11_SHARED_MEM
  switch(videoaccesstype) {
    case VIDEO_XI_SHMSTD:
      XShmPutImage(xWindow->display,xWindow->window, 
		   xWindow->gc,ximage,
		   0, 0, 0, 0, width, height, False);
      XSync(xWindow->display,true); /* Not needed, done by XPending */
      break;
      
      
    case VIDEO_XI_STANDARD:
#endif
      XPutImage(xWindow->display,xWindow->window,
		xWindow->gc, ximage,
		0, 0, 0, 0, width, height);      
      XSync(xWindow->display,true); /* Not needed, done by XPending */
#ifdef X11_SHARED_MEM
      break;
    }
#endif
}



int ImageDeskX11::createImage(int createType,int size) {


  videoaccesstype=VIDEO_XI_NONE;

#ifdef X11_SHARED_MEM
  if(XShmQueryVersion(xWindow->display,&XShmMajor,&XShmMinor,&XShmPixmaps)) {
    if (XShmPixmaps==True) {
      if (createType & VIDEO_XI_SHMSTD) {
	videoaccesstype=VIDEO_XI_SHMSTD;
      }
    }
  } else {
    if (createType & VIDEO_XI_SHMSTD) {
      return ERR_XI_NOSHAREDMEMORY;
    }
  }
#endif
  if (videoaccesstype == VIDEO_XI_NONE) {
    videoaccesstype=createType;
  }
    
  switch(videoaccesstype)
    {
#ifdef X11_SHARED_MEM


    case VIDEO_XI_SHMSTD:

      lXerror=false;
      XSetErrorHandler(dummy);

      shmseginfo=(XShmSegmentInfo *)malloc(sizeof(XShmSegmentInfo));
      if(!shmseginfo)
	return ERR_XI_SHMALLOC;

      memset(shmseginfo,0, sizeof(XShmSegmentInfo));

      switch (size) {
      case _SIZE_NORMAL:
	ximage=XShmCreateImage(xWindow->display,xWindow->visual,
			       xWindow->depth,
			       ZPixmap,NULL,shmseginfo,xWindow->width,
			       xWindow->height);
	break;
      case _SIZE_DOUBLE:
	ximage=XShmCreateImage(xWindow->display,xWindow->visual,
			       xWindow->depth,
			       ZPixmap,NULL,shmseginfo,2*xWindow->width,
			       2*xWindow->height);
	break;
      default:
	cout << "unknown size in imageDeskX11 (SHM)create Image"<<endl;
	ximage=NULL;
      }


      if(!ximage)
	return ERR_XI_SHMXIMAGE;

      shmseginfo->shmid=shmget(IPC_PRIVATE,
			       ximage->bytes_per_line*
			       ximage->height,IPC_CREAT|0777);

      if(shmseginfo->shmid<0)
	return ERR_XI_SHMSEGINFO;
      
      shmseginfo->shmaddr=(char*)shmat(shmseginfo->shmid,NULL,0);
      ximage->data=shmseginfo->shmaddr;
      virtualscreen=(unsigned char *)ximage->data;

      if(!virtualscreen)
	return ERR_XI_SHMVIRTALLOC;

      shmseginfo->readOnly=False;

      XShmAttach(xWindow->display,shmseginfo);
      XSync(xWindow->display, False);
      XSetErrorHandler(NULL);
      XFlush(xWindow->display);
      if (lXerror) {
	cout << "ERR_XI_SHMATTACH -2"<<endl;
	return ERR_XI_SHMATTACH;
      }

      break;
#endif

    case VIDEO_XI_STANDARD:
      switch (size) {
      case _SIZE_NORMAL:
	virtualscreen=(unsigned char *)
	  malloc(xWindow->screensize*sizeof(char));

	if(virtualscreen==NULL)
	  return ERR_XI_VIRTALLOC;

	ximage=XCreateImage(xWindow->display,xWindow->visual,
			    xWindow->depth,ZPixmap,
			    0,(char*)virtualscreen,
			    xWindow->width,xWindow->height,
			    32,xWindow->width*xWindow->pixelsize);
	break;
      case _SIZE_DOUBLE:
	virtualscreen=(unsigned char *)
	  malloc(xWindow->screensize*sizeof(char)*4);

	if(virtualscreen==NULL)
	  return ERR_XI_VIRTALLOC;

	ximage=XCreateImage(xWindow->display,xWindow->visual,
			    xWindow->depth,ZPixmap,
			    0,(char*)virtualscreen,
			    2*xWindow->width,2*xWindow->height,
			    32,2*xWindow->width*xWindow->pixelsize);
	break;
      default:
	cout << "unknown size in imageDeskX11 (SHM)create Image"<<endl;
	ximage=NULL;
      }
     

      if(!ximage)
	return ERR_XI_XIMAGE;
      break;

    default:
      return ERR_XI_FAILURE;

    }

  if ( (videoaccesstype == VIDEO_XI_STANDARD) ||
       (videoaccesstype == VIDEO_XI_SHMSTD) ) {
#ifndef WORDS_BIGENDIAN
    ximage->byte_order = LSBFirst;
    ximage->bitmap_bit_order = LSBFirst;
#else
    ximage->byte_order = MSBFirst;
    ximage->bitmap_bit_order = MSBFirst;
#endif
    
  }
  return ERR_XI_OK;
}



int ImageDeskX11::destroyImage() {
  if(xWindow && xWindow->display && xWindow->window) {
    switch(videoaccesstype) {
#ifdef X11_SHARED_MEM
    case VIDEO_XI_SHMSTD:
      if (shmseginfo) {
	XShmDetach(xWindow->display,shmseginfo);
	if(ximage) {
	  XDestroyImage(ximage);
	  ximage=NULL;
	}
	if(shmseginfo->shmaddr) {
	  shmdt(shmseginfo->shmaddr);
	  shmseginfo->shmaddr=NULL;
	}
	if(shmseginfo->shmid>=0)
	  shmctl(shmseginfo->shmid,IPC_RMID,NULL);
	
	free(shmseginfo);
      }
      shmseginfo=NULL;
      break;
      
#endif
    case VIDEO_XI_STANDARD:
      if(ximage) {
	XDestroyImage(ximage);
	ximage=NULL;
	/*
	  XDestroyImage function calls frees both the image structure
          and the data pointed to by the image structure.
	*/
	virtualscreen=NULL;
      }
      break;

    default:
      cout << "no open window to close"<<endl;
    }
  }
  videoaccesstype=VIDEO_XI_NONE;
  ditherSize=_SIZE_NONE;
  return true;
}
