/*
  xfree 4.0 XV extension desk mode
  Copyright (C) 2000  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __IMAGEXVDESK_H
#define __IMAGEXVDESK_H

#include "xinit.h"

#include "../imageBase.h"


#include <iostream.h>
#include <stdio.h>
#include <unistd.h>
#include <limits.h>
#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <time.h>

//#undef X11_XV

#define GUID_YUV12_PLANAR 0x32315659

/**
   The XV extension dither yuv images in hardware and allows 
   scaling of images.
   But its currently not supported by many drivers.

*/


class ImageXVDesk : public ImageBase {

#ifdef X11_XV
  XvAdaptorInfo		*ai;
  XvEncodingInfo	*ei;
  XvAttribute		*at;
  XvImageFormatValues	*fo;

  XvImage		*yuv_image;


  int		        xv_port;

  int 			shmem_flag;
  XShmSegmentInfo	yuv_shminfo;
#endif

  int lSupport;
  XWindow* xWindow;

 public:
  ImageXVDesk(XWindow* xWindow);
  ~ImageXVDesk();

  int support();

  int openImage(int ditherSize);
  int closeImage();

  void ditherImage(YUVPicture* pic);
  void putImage();

 private:
  int haveXVSupport(XWindow* xWindow);

};

#endif
