// -*- c++ -*-

#ifndef KVNC_H
#define KVNC_H

#include <kmainwindow.h>

class KToggleAction;
class KRFBCanvas;
class QPushButton;

/**
 * Top level window for Keystone.
 *
 * @author Richard Moore, rich@kde.org
 * @version $Id: kvnc.h,v 1.4 2000/09/03 00:43:12 waba Exp $
 */
class KVNC : public KMainWindow
{
  Q_OBJECT
public: 
  KVNC( const char *name = 0 );
  ~KVNC(); 

public slots:
  void toggleFullScreen();
  void toggleShowStatus();
  void toggleShowMenu();
  void openURL( const KURL &url );
  void showOptions();

protected:
  void setupActions();
  void setupMenuBar();
  void setupStatusBar();

protected slots:
  void showAboutApplication();

private:
  bool fullscreen;
  KRFBCanvas *canvas;
  KPopupMenu *cornerMenu;
  QPushButton *cornerButton;
  KToggleAction *menubarAction;
  KToggleAction *statusbarAction;
};

#endif // KVNC_H
