/*
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: apsobject.C
 *
 * Description: Defines the ApsObject class methods.
 *
 */            

#include "apscpp.h"


/*---------------------------------------------------------------------------
 * AddRef()
 *
 * This method adds an additional lock reference to any type of APS object.
 *
 * Parameters: None.
 *
 *     Return: ApsResultObject.
 */
ApsResultObject ApsObject::AddRef()
{
      return (ApsResultObject(Aps_AddRef(handle)));
}
/*---------------------------------------------------------------------------
 * IsOperationAvailable()
 *
 * Checks whether the specified operation is currently available for a
 * particular APS object.
 *
 * Parameters:
 *     operationID : The ID of the operation to be queried. 
 *     anticipatedResult : The address of an Aps_Result to receive 
 *                         APS_OPERATION_AVAILABLE, if this operation is 
 *                         currently unavailable.
 *
 *     Return: ApsResultObject.
 *
 */                              
ApsResultObject ApsObject::IsOperationAvailable(Aps_OperationID operationID, 
                                             Aps_Result *anticipatedResult)
{
     return (ApsResultObject(Aps_IsOperationAvailable(handle, operationID, 
                                                      anticipatedResult)));
}
/*---------------------------------------------------------------------------
 * SetHandle()
 *
 * This method sets the value of the handle data member.
 *
 * Parameters:
 *     apsHandle : the value of the handle data member to be set to.
 *
 *     Return: ApsResultObject.
 *
 */                              
ApsResultObject ApsObject::SetHandle(Aps_Handle apsHandle)
{
     Aps_Result resultCode ;

     resultCode = Aps_AddRef(apsHandle);
     if (Aps_Succeeded(resultCode)){
           if (handle != NULL){
               resultCode = Aps_ReleaseHandle(handle);
               if (Aps_Succeeded(resultCode))
                   return (ApsResultObject(resultCode));
           }
           handle = apsHandle;
     }
     return (ApsResultObject(resultCode));
}
/*---------------------------------------------------------------------------
 * ReleaseHandle()
 *
 * This method releases the handle and set its value to NULL.
 *
 * Parameters: None.
 *
 *     Return: ApsResultObject.
 *
 */                              
ApsResultObject ApsObject::ReleaseHandle()
{
     Aps_Result resultCode ;

     resultCode = Aps_ReleaseHandle(handle); 
     if (Aps_Succeeded(resultCode))
	     handle = NULL;
     return (ApsResultObject(resultCode));
}
/*---------------------------------------------------------------------------
 * ReleaseBuffer()
 *
 * This method releases the buffer associated with any pointer resturned by 
 * APS library function/C++ interface method.
 *
 * Parameters: 
 *     buffer : The buffer to be freed.
 *
 *     Return: ApsResultObject.
 *
 */                              
ApsResultObject ApsObject::ReleaseBuffer(void *buffer)
{
     return (ApsResultObject(ReleaseBuffer(buffer)));
}
/*---------------------------------------------------------------------------
 * Destructor()
 *
 * This method checks the value of the handle and calls ReleaseHandle to free 
 * it if it is not NULL.
 *
 * Parameters: None.
 *
 *     Return: ApsResultObject.
 *
 */                              
ApsObject::~ApsObject()
{
     if (handle != NULL)
          ReleaseHandle();
}
