/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: bufferarray.h
 *
 * Description: Facilities for constructing and managing arrays of strings
 *              or other data structures. BufferArrays are specifically
 *              designed to meet the needs of an interface that needs to
 *              pass an array and its contents in a single block of memory
 *              (i.e. a *Buffer*) from one component to another.
 */

#ifndef BUFFERARRAY_H
#define BUFFERARRAY_H

#include "aps.h"

typedef void *BufferArray;

Aps_Result BufArrCreate(BufferArray * array);
Aps_Result BufArrCreateCopy(BufferArray * newArray, BufferArray existingArray);
void BufArrDelete(BufferArray array);
Aps_Result BufArrChangeToSingleBuffer(BufferArray oldArray, void ***buffer,
                                      int *numElems);
Aps_Result BufArrAddString(BufferArray array, const char *string);
Aps_Result BufArrAdd(BufferArray array, const void *element, int size);
Aps_Result BufArrAddUninitialized(BufferArray array, int size,
                                  void **element);
Aps_Result BufArrAddSecondaryBlock(BufferArray array, int size,
                                   void **block);
int BufArrGetSize(BufferArray array);
void *BufArrGetAt(BufferArray array, int index);
Aps_Result BufArrSetStringAt(BufferArray array, int index,
                             const char *string);
Aps_Result BufArrSetAt(BufferArray array, int index, const void *element,
                       int size);
Aps_Result BufArrInsertStringAt(BufferArray array, int index,
                                const char *string);
Aps_Result BufArrInsertAt(BufferArray array, int index, const void *element,
                          int size);
Aps_Result BufArrInsertAtUninitialized(BufferArray array, int index,
                                       int size, void **element);
                          
#endif /* BUFFERARRAY_H */
