/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: iscupsrunning.c
 *
 * Description: Performs a run-time check to determine whether the CUPS
 *              printing system is running on this machine.
 */
 
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <fcntl.h>
#include <getopt.h>
#include <pwd.h>
#include <dirent.h>
#include <termios.h>
/* #include <termcap.h> */
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>

#include "apsinternal.h"

DEBUG_CHANNEL_DEFAULT(cups)

#ifndef MAX_DEPTH
#define MAX_DEPTH    100
#endif
#define COMM_LEN     16

/* Not used now:
   static int pids = 0;
   static output_width = 132;
   extern IsCupsRunning(void);
*/
/* This function isn't exported anywhere now?? */
int IsCupsRunning(void);

int IsCupsRunning(void)
{
    DIR *dir;
    struct dirent *de;
    FILE *file;
    struct stat st;
    char path[APSCFG_MAX_PATH_SIZE], comm[COMM_LEN + 1];
    pid_t pid, ppid;
    int found = 0;
    int dummy;

    if (!(dir = opendir(APSCFG_PATH_PROC_DIR))) {
        perror(APSCFG_PATH_PROC_DIR);
        exit(1);
    }
    while ( (de = readdir(dir)) )
        if ( (pid = atoi(de->d_name)) ) {
            sprintf(path, "%s/%d/stat", APSCFG_PATH_PROC_DIR, pid);
            if ( (file = fopen(path, "r")) ) {
                if (fstat(fileno(file), &st) < 0) {
                    perror(path);
                    exit(1);
                }
                if (fscanf(file, "%d (%[^)]) %c %d", &dummy, comm,
                           (char *)&dummy, &ppid) == 4) {
                    if (!strcmp(comm, "cupsd")) {
                        found = 1;
                    }
                }
                (void)fclose(file);
                if (found == 1)
                    break;
            }
        }
    (void)closedir(dir);
    if (found == 0)
        return (0);
    else
        return (1);

}
