/*
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: lprprefs.h
 *
 * Description: Preferences functions used by LprTransport.
 *
 * N.B. This is where C++ templates would REALLY come in handy!!! *sigh*
 */

#ifndef LPRPREFS_H
#define LPRPREFS_H

/* These structure hold information stored in the filter configs.
 * They may be disposed of later...
 */
typedef struct { /* Printtool-style textonly.cfg */
    struct { FILE *fh; int fd; } private;
    char *txtOptions;        /* TEXTONLYOPTIONS= */
    BOOL  txtAddCR;          /* CRLFTRANS= */
    BOOL  txtSendEOF;        /* TEXT_SEND_EOF= */
} LprFilterRH_TextOnlyCfg;
typedef struct { /* Printtool-style postscript.cfg */
    struct { FILE *fh; int fd; } private;
    char *psGSDevice;        /* GSDEVICE= */
    char *psGSOptions;       /* EXTRA_GS_OPTIONS= */
    char *psGSUniprintDrv;   /* COLOR= */
    int   psXDPI, psYDPI;    /* RESOLUTION=<xdpi>x<ydpi> */
    char *psPaperSize;       /* PAPER_SIZE= */
    BOOL  psReverseOrder;    /* REVERSE_ORDER= */
    BOOL  psSendEOF;         /* PS_SEND_EOF= */
    int   psNUPCount;        /* NUP= */
    int   psNUPHMargin;      /* RTLFTMAR= */
    int   psNUPVMargin;      /* TOPBOTMAR= */
} LprFilterRH_PostscriptCfg;
typedef struct { /* Printtool-style general.cfg */
    struct { FILE *fh; int fd; } private;
    char *genDesired;        /* DESIRED_TO= */
    char *genPaperSize;      /* PAPER_SIZE= */
    Aps_ConnectionType genPrinterType; /* PRINTER_TYPE= */
    BOOL  genASCIItoPS;      /* ASCII_TO_PS= */
} LprFilterRH_GeneralCfg;
typedef struct { /* Printtool-style SMB .config / .config.user */
    struct { FILE *fh; int fd; } private;
    char *smbHostIP;         /* hostip= */
    char *smbShare;          /* share= */
    char *smbUser;           /* user= */
    char *smbPassword;       /* password= */
} LprFilterRH_SMBNetworkCfg;
typedef struct { /* Printtool-style LPD .config */
    struct { FILE *fh; int fd; } private;
    char *lpdServer;         /* server= */
    char *lpdQueue;          /* queue= */
    char *lpdUser;           /* user= */
    char *lpdPassword;       /* password= */
} LprFilterRH_LPDNetworkCfg;

/* Protos */
Aps_Result LprFilterRH_txtcfgInit(LprFilterRH_TextOnlyCfg *cfg);
Aps_Result LprFilterRH_pscfgInit(LprFilterRH_PostscriptCfg *cfg);
Aps_Result LprFilterRH_gencfgInit(LprFilterRH_GeneralCfg *cfg);
Aps_Result LprFilterRH_smbcfgInit(LprFilterRH_SMBNetworkCfg *cfg);
Aps_Result LprFilterRH_lpdcfgInit(LprFilterRH_LPDNetworkCfg *cfg);

Aps_Result LprFilterRH_txtcfgRelease(LprFilterRH_TextOnlyCfg *cfg);
Aps_Result LprFilterRH_pscfgRelease(LprFilterRH_PostscriptCfg *cfg);
Aps_Result LprFilterRH_gencfgRelease(LprFilterRH_GeneralCfg *cfg);
Aps_Result LprFilterRH_smbcfgRelease(LprFilterRH_SMBNetworkCfg *cfg);
Aps_Result LprFilterRH_lpdcfgRelease(LprFilterRH_LPDNetworkCfg *cfg);

Aps_Result LprFilterRH_txtcfgRead(const char *spoolDir,
    LprFilterRH_TextOnlyCfg *cfg);
Aps_Result LprFilterRH_pscfgRead(const char *spoolDir,
    LprFilterRH_PostscriptCfg *cfg);
Aps_Result LprFilterRH_gencfgRead(const char *spoolDir,
    LprFilterRH_GeneralCfg *cfg);
Aps_Result LprFilterRH_smbcfgRead(const char *spoolDir,
    LprFilterRH_SMBNetworkCfg *cfg);
Aps_Result LprFilterRH_lpdcfgRead(const char *spoolDir,
    LprFilterRH_LPDNetworkCfg *cfg);

Aps_Result LprFilterRH_txtcfgWrite(const char *spoolDir,
    LprFilterRH_TextOnlyCfg *cfg);
Aps_Result LprFilterRH_pscfgWrite(const char *spoolDir,
    LprFilterRH_PostscriptCfg *cfg);
Aps_Result LprFilterRH_gencfgWrite(const char *spoolDir,
    LprFilterRH_GeneralCfg *cfg);
Aps_Result LprFilterRH_smbcfgWrite(const char *spoolDir,
    LprFilterRH_SMBNetworkCfg *cfg);
Aps_Result LprFilterRH_lpdcfgWrite(const char *spoolDir,
    LprFilterRH_LPDNetworkCfg *cfg);

Aps_Result LprFilterRH_txtcfgWriteDefer(const char *spoolDir,
    LprFilterRH_TextOnlyCfg *cfg);
Aps_Result LprFilterRH_pscfgWriteDefer(const char *spoolDir,
    LprFilterRH_PostscriptCfg *cfg);
Aps_Result LprFilterRH_gencfgWriteDefer(const char *spoolDir,
    LprFilterRH_GeneralCfg *cfg);
Aps_Result LprFilterRH_smbcfgWriteDefer(const char *spoolDir,
    LprFilterRH_SMBNetworkCfg *cfg);
Aps_Result LprFilterRH_lpdcfgWriteDefer(const char *spoolDir,
    LprFilterRH_LPDNetworkCfg *cfg);

Aps_Result LprFilterRH_txtcfgWriteCommit(const char *spoolDir,
    LprFilterRH_TextOnlyCfg *cfg);
Aps_Result LprFilterRH_pscfgWriteCommit(const char *spoolDir,
    LprFilterRH_PostscriptCfg *cfg);
Aps_Result LprFilterRH_gencfgWriteCommit(const char *spoolDir,
    LprFilterRH_GeneralCfg *cfg);
Aps_Result LprFilterRH_smbcfgWriteCommit(const char *spoolDir,
    LprFilterRH_SMBNetworkCfg *cfg);
Aps_Result LprFilterRH_lpdcfgWriteCommit(const char *spoolDir,
    LprFilterRH_LPDNetworkCfg *cfg);

Aps_Result LprFilterRH_txtcfgWriteAbort(const char *spoolDir,
    LprFilterRH_TextOnlyCfg *cfg);
Aps_Result LprFilterRH_pscfgWriteAbort(const char *spoolDir,
    LprFilterRH_PostscriptCfg *cfg);
Aps_Result LprFilterRH_gencfgWriteAbort(const char *spoolDir,
    LprFilterRH_GeneralCfg *cfg);
Aps_Result LprFilterRH_smbcfgWriteAbort(const char *spoolDir,
    LprFilterRH_SMBNetworkCfg *cfg);
Aps_Result LprFilterRH_lpdcfgWriteAbort(const char *spoolDir,
    LprFilterRH_LPDNetworkCfg *cfg);

#endif /* !LPRPREFS_H */
