/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: lprprinter.h
 *
 * Description: Implementation of a printer object used by the lpr transport.
 *
 */

#ifndef LPRPRINTER_H
#define LPRPRINTER_H

typedef struct LprPrinter_ LprPrinter;

#include "printer.h"
#include "job.h"

/* Structure containing information specific to the lpr printer object. */
struct LprPrinter_ {
    Printer baseClass;

    /* Queue cache */
    Job *queueHead;   /* head of doubly-linked list */
    Job *queueTail;   /* tail of doubly-linked list */
};

/* Creates a new LprPrinter object */
LprPrinter *LprCreatePrinter(const char *name, void *transport);

#endif /* !LPRPRINTER_H */
