/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: notificationsub.h
 *
 * Description: Implementation of the NotificationSub object, and instance
 *              of which exists for each subscription that the application
 *              registers in order to be notified when a particular event
 *              takes place.
 */

#ifndef NOTIFICATIONSUB_H
#define NOTIFICATIONSUB_H

typedef struct NotificationSub_ NotificationSub;

#include "object.h"

struct NotificationSub_ {
    ApsObject baseClass;

    ApsObject *associatedObject;
    Aps_Event eventType;
    Aps_NotificationCallback callbackFunction;
    void *appData;
};

NotificationSub *NotificationGetPtrFromHandle(Aps_NotificationHandle handle);
Aps_NotificationHandle NotificationGetHandleFromPtr(
                                          NotificationSub * notificationSub);
Aps_Result NotificationCreate(NotificationSub ** notificationSub);
void NotificationDelete(NotificationSub * notificationSub);
Aps_Result NotificationAttachCB(NotificationSub * notificationSub,
                                ApsObject *associatedObject,
                                Aps_Event event,
                                Aps_NotificationCallback callbackFunction,
                                void *appData);
void NotificationDetach(NotificationSub * notificationSub,
                        ApsObject *associatedObject);
int NotificationMatchesEvent(NotificationSub * notificationSub,
                             Aps_Event event);
void NotificationSend(NotificationSub * notificationSub, ApsObject *object,
                      Aps_Event event, void *eventData);

#endif /* !NOTIFICATIONSUB_H */
