/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: pointerarray.h
 *
 * Description: Manages an array of pointers to arbitrary objects.
 */

#ifndef POINTERARRAY_H
#define POINTERARRAY_H

#include "aps.h"

typedef void *PointerArray;

Aps_Result PtrArrCreate(PointerArray * array);
void PtrArrDelete(PointerArray array);
Aps_Result PtrArrAdd(PointerArray array, void *element);
int PtrArrGetSize(PointerArray array);
void *PtrArrGetAt(PointerArray array, int index);
void PtrArrSetAt(PointerArray array, int index, void *element);
Aps_Result PtrArrInsertAt(PointerArray array, int index, void *element);
void PtrArrRemoveAt(PointerArray array, int index, int numElements);

#endif /* POINTERARRAY_H */
