/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: ppdattrprovider.h
 *
 * Description: Header file for the PPD attribute provider object.
 *
 */

#ifndef PPDATTRPROVIDER_H
#define PPDATTRPROVIDER_H

#include "attrprovider.h"
#include "ppdmanager.h"
#include "jobattributes.h"

/* Structure of data stored for each instance of a PPD Attribute Provider. */
typedef struct {
    AttrProvider baseClass;
    PPDHandle ppdManager;
} PPDAttrProvider;

/* Function to create a new PPD Attribute Provider instance. */
Aps_Result PPDAttrCreate(PPDAttrProvider ** attrProvider,
                         Aps_Handle associatedObject);

#endif /* PPDATTRPROVIDER_H */
