/*
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: ppdmanager.h
 *
 * Description: PPD Manager is a library with an interface allowing the user 
 *              to query PPD (PostScript Printer Descriction) files, and to 
 *              create custom PPD files.  The library also contains methods 
 *              specific to building user interfaces.
 *
 */

#ifndef PPDMANAGER_H
#define PPDMANAGER_H

typedef void *PPDHandle;
typedef void *PPDPosition;

#define PPD_UI_TYPE_UNDEFINED 0
#define PPD_UI_TYPE_BOOLEAN   1
#define PPD_UI_TYPE_PICK_ONE  2
#define PPD_UI_TYPE_PICK_MANY 3


PPDHandle PPDCreate(void);
int PPDDestroy(PPDHandle ppdHandle);

PPDHandle PPDCreateCopy(PPDHandle ppdHandle);

int PPDSetFilename(PPDHandle ppdHandle, const char *ppdFilename);
int PPDGetFilename(PPDHandle ppdHandle, char **ppdFilename);

int PPDIsCustomPPD(PPDHandle ppdHandle);
int PPDSaveToCustomPPD(PPDHandle ppdHandle, const char *ppdFilename);
int PPDSaveToEmbeddedCustomPPD(PPDHandle ppdHandle, const char *ppdFilename);

int PPDDeleteString(PPDHandle ppdHandle, char **ppdString);

int PPDGetJCLHeader(PPDHandle ppdHandle, char **jclString);
int PPDGetJCLFooter(PPDHandle ppdHandle, char **jclString);
int PPDGetJobPatch(PPDHandle ppdHandle, char **psString);
int PPDGetPSSetup(PPDHandle ppdHandle, char **psString);

int PPDUseCustomPageSize(PPDHandle ppdHandle, double width, double height,
                         double widthOffset, double heightOffset, 
			 int orientation);
int PPDUseStandardPageSize(PPDHandle ppdHandle);

int PPDDoesKeyExist(PPDHandle ppdHandle, const char *mainKey);

int PPDGetKey(PPDHandle ppdHandle, const char *mainKey, char **value,
              char **valueTranslated);
int PPDGetKeyWithOption(PPDHandle ppdHandle, const char *mainKey,
                        const char *optionKey, char **optionKeyTranslated,
                        char **value, char **valueTranslated);

int PPDGetDefaultKey(PPDHandle ppdHandle, const char *mainKey,
                     char **defaultValue);
int PPDSetDefaultKey(PPDHandle ppdHandle, const char *mainKey,
                     const char *defaultValue);

int PPDCheckForUIConstraints(PPDHandle ppdHandle, const char *mainKey,
                             const char *value, char **conflictingMainKey,
                             char **conflictingValue);

int PPDIterateEnd(PPDHandle ppdHandle, PPDPosition * pos);

int PPDGetKeysIterateStart(PPDHandle ppdHandle, PPDPosition * pos,
                           const char *mainKey);
int PPDGetKeysIterateNext(PPDHandle ppdHandle, PPDPosition * pos, char **mainKey,
                          char **optionKey, char **optionKeyTranslated,
                          char **value, char **valueTranslated);

int PPDGetGroupsIterateStart(PPDHandle ppdHandle, PPDPosition * pos);
int PPDGetGroupsIterateNext(PPDHandle ppdHandle, PPDPosition * pos,
                            char **value, char **valueTranslated);

int PPDGetSubGroupsIterateStart(PPDHandle ppdHandle, PPDPosition * pos,
                                const char *group);
int PPDGetSubGroupsIterateNext(PPDHandle ppdHandle, PPDPosition * pos,
                               char **value, char **valueTranslated);

int PPDGetUIsIterateStart(PPDHandle ppdHandle, PPDPosition * pos,
                          const char *group);
int PPDGetUIsIterateNext(PPDHandle ppdHandle, PPDPosition * pos,
                         char **optionKey, char **optionKeyTranslated,
                         int *type);

int PPDGetAllUIsIterateStart(PPDHandle ppdHandle, PPDPosition * pos);
int PPDGetAllUIsIterateNext(PPDHandle ppdHandle, PPDPosition * pos,
                            char **optionKey, char **optionKeyTranslated,
                            int *type);

int PPDGetUI(PPDHandle ppdHandle, const char *optionKey, 
             char **optionKeyTranslated, int *type);

#endif /* PPDMANAGER_H */
