/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: apsinternal.h
 *
 * Description: Main header file for internal definitions and
 *              declarations for the APS library.
 *
 */

#ifndef APSINTERNAL_H
#define APSINTERNAL_H

#include "../config.h"
#include <stdlib.h>

/* define TRUE/FALSE/NULL if not present */
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef NULL
#define NULL 0
#endif

/* Boolean type used only internally by the APS library. */
typedef int BOOL;

#include "aps.h"
#include "debug.h"

/*** If inlining is enabled, we will instantiate static versions of
 *** the functions here, else they are instantiated in generalpurpose.c
 ***/
#if (APSCFG_INLINE)
#define TRACKARRAY_STORAGE static INLINE
#else
#define TRACKARRAY_STORAGE
#endif

#include "trackmem.h"
#include "trackarray.h"

/* Declare all the TrackArray template types we use
 * -- instantiate in generalpurpose.c */
TrackArray_Declare(PtrChar, char *)
TrackArray_Declare(PtrQuickJobInfo, Aps_QuickJobInfo *)
TrackArray_Declare(PtrQuickPrinterQInfo, Aps_QuickPrinterQInfo *)
TrackArray_Declare(PtrAttrOption, Aps_AttrOption *)
TrackArray_Declare(PtrResolution, Aps_Resolution *)
TrackArray_Declare(PtrFontInfo, Aps_FontInfo *)
TrackArray_Declare(PtrPageSize, Aps_PageSize *)

TrackArrayIndirect_Declare(QuickJobInfo, PtrQuickJobInfo,
    Aps_QuickJobInfo)
TrackArrayIndirect_Declare(QuickPrinterQInfo, PtrQuickPrinterQInfo,
    Aps_QuickPrinterQInfo)
TrackArrayIndirect_Declare(AttrOption, PtrAttrOption, Aps_AttrOption)
TrackArrayIndirect_Declare(Resolution, PtrResolution, Aps_Resolution)
TrackArrayIndirect_Declare(FontInfo, PtrFontInfo, Aps_FontInfo)
TrackArrayIndirect_Declare(PageSize, PtrPageSize, Aps_PageSize)

/* Implement all the TrackArray template types we use
 * -- declare in apsinternal.h */
#if (APSCFG_INLINE)
TrackArray_Implement(PtrChar)
TrackArray_Implement(PtrQuickJobInfo)
TrackArray_Implement(PtrQuickPrinterQInfo)
TrackArray_Implement(PtrAttrOption)
TrackArray_Implement(PtrResolution)
TrackArray_Implement(PtrFontInfo)
TrackArray_Implement(PtrPageSize)
TrackArrayIndirect_Implement(QuickJobInfo, PtrQuickJobInfo)
TrackArrayIndirect_Implement(QuickPrinterQInfo, PtrQuickPrinterQInfo)
TrackArrayIndirect_Implement(AttrOption, PtrAttrOption)
TrackArrayIndirect_Implement(Resolution, PtrResolution)
TrackArrayIndirect_Implement(FontInfo, PtrFontInfo)
TrackArrayIndirect_Implement(PageSize, PtrPageSize)
#endif

#endif /* !APSINTERNAL_H */
