/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: filter.h
 *
 * Description:
 *
 */

#ifndef FILTER_H
#define FILTER_H

typedef struct Filter_ Filter;
typedef struct FilterQual_ FilterQual;
typedef struct FilterData_Function_ FilterData_Function;
typedef enum FilterType_ FilterType;
typedef enum FilterSpecial_ FilterSpecial;

#include "aps.h"
#include "apsinternal.h"
#include "object.h"

/* Types for filter comparisons */
typedef char *    XString;
typedef int       XInt;
typedef long int  XBitfield;
typedef time_t    XTime;

/* Filter types */
enum FilterType_ {
    FILTER_TYPE_NONE = 0, /* matches nothing */
    FILTER_TYPE_ALL,      /* matches everything */
    FILTER_TYPE_EMBED,    /* matched by embedded filter */
    FILTER_TYPE_FUNCTION, /* matches by function */
    FILTER_TYPE_SPECIAL,  /* matches certain internal fields */
};

/* Filter special fields */
enum FilterSpecial_ {
    FILTER_SPECIAL_NONE = 0,
    /* For JOB objects -- matches named field
     * -- comment indicates what void *data points to */
    FILTER_SPECIAL_JOB_BASE = 0x1000,
    FILTER_SPECIAL_JOB_jobStatus,       /* bitfield */
    FILTER_SPECIAL_JOB_jobHost,         /* string */
    FILTER_SPECIAL_JOB_jobName,         /* string */
    FILTER_SPECIAL_JOB_jobFilename,     /* string */
    FILTER_SPECIAL_JOB_jobID,           /* int */
    FILTER_SPECIAL_JOB_jobSize,         /* int */
    FILTER_SPECIAL_JOB_jobCreationTime, /* time */
    FILTER_SPECIAL_JOB_jobFormat,       /* string */
    FILTER_SPECIAL_JOB_jobOrder,        /* int */
    FILTER_SPECIAL_JOB_jobPriority,     /* int */
    FILTER_SPECIAL_JOB_printerStatus,   /* bitfield */
    FILTER_SPECIAL_JOB_printerName,     /* string */
    FILTER_SPECIAL_JOB_docTitle,        /* string */
    FILTER_SPECIAL_JOB_docRevision,     /* string */
    FILTER_SPECIAL_JOB_docComments,     /* string */
    FILTER_SPECIAL_JOB_docAuthor,       /* string */
    FILTER_SPECIAL_JOB_docType,         /* string */
    FILTER_SPECIAL_JOB_docCreator,      /* string */
    FILTER_SPECIAL_JOB_ownerName,       /* string */
    FILTER_SPECIAL_JOB_ownerID,         /* int */
    FILTER_SPECIAL_JOB_localHost,       /* string */
    FILTER_SPECIAL_JOB_localFile,       /* string */
    FILTER_SPECIAL_JOB_spoolHost,       /* string */
    FILTER_SPECIAL_JOB_spoolFile        /* string */
    /* For other objects alloc in new block
     * eg. FILTER_SPECIAL_XXX_BASE = 0x2000,
     */
};

/* Core filter object
 * Holds a circular linked list of filter qualifications
 */
struct Filter_ {
    ApsObject baseClass;  /* baseclass */
    FilterQual *tail;     /* tail of list */
};

/* Filter qualification
 * Each structure must be allocated as a single entity from the heap so
 * that any associated data may be freed by a single call to free().
 */
struct FilterQual_ {
    FilterQual    *next;          /* next element in list */
    FilterType     filterType;    /* filter type */
    FilterSpecial  filterSpecial; /* special sub-types */
    Aps_FilterMode filterMode;    /* mode to apply to this qualifier */
    void          *data;          /* pointer to data space */
};

/* Filter storage data for callback functions */
struct FilterData_Function_ {
    Aps_FilterFunc  func;
    void           *arg;
};

/* Internal protos */
Filter *FilterGetPtrFromHandle(Aps_FilterHandle handle);
Aps_FilterHandle FilterGetHandleFromPtr(Filter *filter);
void FilterDelete(Filter *filter);
Aps_Result FilterCheckSpecial(FilterQual *qual,
    Aps_Handle objHandle, int *match);
FilterQual *FilterAllocQual(FilterType filterType,
    FilterSpecial filterSpecial, Aps_FilterMode filterMode,
    size_t sizeAuxData);
Aps_Result FilterLink(Aps_FilterHandle *filterHandle, FilterQual *filterQual);


#endif /* !FILTER_H */
