/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: jobattributes.h
 *
 * Description: Generic printer JobAttributes implementation.
 *
 */

#ifndef JOBATTRIBUTES_H
#define JOBATTRIBUTES_H

typedef struct JobAttributes_ JobAttributes;

#include "aps.h"
#include "apsinternal.h"
#include "attrprovider.h"
#include "object.h"
#include "printer.h"

struct JobAttributes_ {
    ApsObject baseClass;
    AttrProvider *attributeProviders[APSCFG_ATTR_MAX_PROVIDERS];
    int numProviders;
};

JobAttributes *JobAttrGetPtrFromHandle(Aps_JobAttrHandle handle);
Aps_JobAttrHandle JobAttrGetHandleFromPtr(JobAttributes * attributes);
JobAttributes *JobAttrCreate(void);
JobAttributes *JobAttrCreateCopy(const JobAttributes * source);
void JobAttrDelete(JobAttributes * attributes);
Aps_Result JobAttrSetToModelDefaults(JobAttributes * attributes,
                                     Printer * printer);
Aps_Result JobAttrSaveAsPrinterDefaults(JobAttributes * attributes,
                                        Printer * printer);
Aps_Result JobAttrSetToPrinterDefaults(JobAttributes * attributes,
                                       Printer * printer);
Aps_Result JobAttrRemovePrinterDefaults(JobAttributes * attributes,
                                        Printer * printer);

#endif /* !JOBATTRIBUTES_H */
