/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: utils.h
 *
 * Description: Implementation of General utility APIs.
 */

#ifndef UTILS_H
#define UTILS_H

#include <stdio.h>

Aps_Result GetCommandOutput(
    const char *cliCommand, /* shell command */
    const char *cliArg,     /* command arguments -- format string */
    const char *cliCWD,     /* current working dir for shell command */
    int   maxWait,          /* max time to wait for input */

    char ***cmdOutput,      /* returned, buffer */
    int    *outNumLines,    /* returned, number of lines */
    int    *cmdReturn,      /* returned, command's return code */

    ...);                   /* substitution values for arguments */

int strstrip(char *dest, const char *src, const char *chars);

int strtrim(char *dest, const char *src);

int strdelimit(char *dest, const char *src, const char *chars, char dchar);

char *strupdate(char **dest, const char *src);

size_t strtotallen(const char *str);

char *strcpyupdate(char **dest, const char *src);

int strisdef(const char *str);

char *strupdatehostname(char **str);

char *strupdatejoin(char **dest, const char *src1, const char *src2);

int strcmpwild(const char *match, const char *target, int icase);

int strunquot(char *target, const char *source, const char *quote);

Aps_Result StrDupWithNull(char **dest, const char *src);

Aps_Result FindProgram(const char *cmdName, const char *pathHint,
    char **prgPath);

Aps_Result FindFile(const char *fileName, const char *pathHint,
    char **filePath);

int RemoveDirectory(char *directory, char *newDir);
char *path_alloc(int *size);
int GetScriptOutput(const char* printerName, const char* ifFilterPath,
                    char** gsDevice, char** resolution );

Aps_Result CopyFileSpecial(
    const char *srcDir, const char *srcFile,
    const char *destDir, const char *destFile,
    mode_t newProtection, uid_t newOwner, gid_t newGroup);

Aps_Result CopyFileToEnd(FILE *dest, FILE *src);

/*********************************************
 *** REPLACE MISSING LIBRARY FUNCTIONALITY ***
 *********************************************/

#ifdef APSCFG_NEED_STRICMP
int stricmp(const char *str1, const char *str2);
#endif /* APSCFG_NEED_STRNICMP */

#ifdef APSCFG_NEED_STRNICMP
int strnicmp(const char *str1, const char *str2, size_t num);
#endif /* APSCFG_NEED_STRNICMP */

#ifdef APSCFG_NEED_STRDUP
char *strdup(const char *str);
#endif /* APSCFG_NEED_STRDUP */

#endif /* UTILS_H */

