/*
 * Application Print Services Library (APS)
 *
 * This file uses the symbols generated during auto-configuration to
 * produce cooked symbols for use by the library.
 *
 * If you need to export a new resource from configure.in, please
 * consider providing and using a stub in this section.
 *
 * N.B. This would REALLY benefit from precompiled headers.  Please don't
 *      move this stuff directly into the configure.in file as it is
 *      much easier to maintain when in one place.  Using the C preprocessor
 *      to resolve many configuration issues is still fairly inexpensive.
 */

/* Imported symbols:
 *  APSCFG_CUPS_BUILD
 *  APSCFG_DEBUG
 *  APSCFG_DEBUG_PARANOID
 *  APSCFG_DEBUG_TRACE
 *  APSCFG_DEBUG_DEF_CHANNELS
 *  APSCFG_LPR_BUILD
 *  APSCFG_LPR_LET_DAEMON_MANAGE_NETWORKS
 *  APSCFG_MALLOC_DATAALIGN
 *  APSCFG_MALLOC_LIB
 *  APSCFG_MALLOC_USERALIGN
 *  APSCFG_MAX_PATH_SIZE
 *  APSCFG_INLINE
 *  const
 *  HAVE_CUPS_CUPS_H
 *  HAVE_PATHCONF
 *  HAVE_STRCASECMP
 *  HAVE_STRDUP
 *  HAVE_STRICMP
 *  HAVE_STRNICMP
 *  HAVE_STRNCASECMP
 *  inline
 *  SIZEOF_CHAR
 *  SIZEOF_DOUBLE
 *  SIZEOF_INT
 *  SIZEOF_VOID_P
 *  STAT_MACROS_BROKEN
 */


/************************
 *** COMPILER SUPPORT ***
 ************************/

/*** const: Keyword to use for const
 *
 * Dummy macro produced by auto-configuration script
 */

/*** APSCFG_INLINE_KEYWORD: Keyword to use for inlining
 *
 * Defines the keyword to use for function inlining.  Some C compilers
 * use inline, __inline, or __inline__, or simply fail to provide such
 * services.  If blank and inlining is enabled, APS will try to use
 * macros or other means wherever possible / useful.
 *
 * Default: as specified by AC_C_INLINE macro
 *
 * Note: if the "inline" symbol is undefined, then the inline keyword exists.
 */
#ifdef inline /* if defined to something else, set up our symbol, and undef */
#define APSCFG_INLINE_KEYWORD inline
#undef inline
#else
#define APSCFG_INLINE_KEYWORD inline /* inline keyword exists */
#endif

/*** APSCFG_INLINE: Use inlining
 *   ./configure --[enable/disable]-inline
 *
 * If TRUE, enables inlining.
 *
 * Default: 1 (if not imported from config.h)
 *
 * [Note: Does not support #pragma-based inline schemes]
 */
#ifndef APSCFG_INLINE
#define APSCFG_INLINE 1
#endif

/* Setup INLINE and inline macro keywords */
#if (APSCFG_INLINE)
#define INLINE APSCFG_INLINE_KEYWORD
#else
#define INLINE
#endif

/***************************
 *** ENVIRONMENT SUPPORT ***
 ***************************/

/*** APSCFG_STAT_BROKEN: #ifdef switch if S_ISDIR() etc... cannot be trusted
 *
 * Default: as specified by STAT_HEADERS_BROKEN
 */
#ifdef STAT_HEADERS_BROKEN
#define APSCFG_STAT_BROKEN
#endif

/*****************
 *** DEBUGGING ***
 *****************/

/*** APSCFG_DEBUG: Global enable/disable debugging support
 *   ./configure --[enable/disable]-debug
 *
 * If FALSE, then no debugging output, run-time assertions or
 * tracing will be supported.
 *
 * Default: 0 (if not imported from config.h)
 */
#ifndef APSCFG_DEBUG
#define APSCFG_DEBUG 0
#endif
#undef DEBUG
#if (APSCFG_DEBUG)
#define DEBUG /* recognized by some APS-independant modules */
#endif

/*** APSCFG_DEBUG_PARANOID: Enable/disable for heavy debug checks
 *   ./configure --[enable/disable]-debug=paranoid
 *
 * If TRUE, enables any heavy/intensive debug checks which may be
 * particularly costly in a production enviroment.
 *
 * Default: 0 (if not imported from config.h)
 */
#ifndef APSCFG_DEBUG_PARANOID
#define APSCFG_DEBUG_PARANOID 0
#endif

/*** APSCFG_DEBUG_TRACE: Enable/disable for program flow tracing
 *   ./configure --[enable/disable]-debug-trace
 *
 * If TRUE, enables run-time program flow tracing if debugging is
 * enabled.
 *
 * Bitmapped by debug message class:
 *   1 - msg
 *   2 - warn
 *   4 - error
 *   8 - fixme
 *  16 - trace
 *
 * Default: 0 (if not imported from config.h)
 */
#ifndef APSCFG_DEBUG_TRACE
#if (APSCFG_DEBUG)
#define APSCFG_DEBUG_TRACE 15
#else
#define APSCFG_DEBUG_TRACE 0
#endif
#else
#if ((APSCFG_DEBUG_TRACE) && (! APSCFG_DEBUG))
#warning "APSCFG_DEBUG_TRACE selected, but all debugging disabled"
#undef APSCFG_DEBUG_TRACE
#define APSCFG_DEBUG_TRACE 0
#endif
#endif

/*** APSCFG_DEBUG_DEF_CHANNELS: Default channels and messages to enable
 *   ./configure --default-channels
 *
 * Specifies the default set of channels to be enabled.  Channels are
 * listed in the standard string format.  "[channel{+-}class[,...]]"
 *
 * Default: "all+error,all+fixme" (if not imported from config.h)
 */
#ifndef APSCFG_DEBUG_DEF_CHANNELS
#define APSCFG_DEBUG_DEF_CHANNELS "all+error,all+fixme"
#endif

/*** APSCFG_DEBUG_VAR_CHANNELS: Name of environment variable for channels.
 *
 * Specifies the name of an environment variable which will be examined
 * at run-time for a list of channels and classes to be enabled for
 * tracing.  Setting this string to "" or NULL disables the feature.
 *
 * Default: "APSTRACE"
 */
#ifndef APSCFG_DEBUG_VAR_CHANNELS
#define APSCFG_DEBUG_VAR_CHANNELS "APSTRACE"
#endif

/*** APSCFG_DEBUG_WIDTH_LINDENT  : size of left message indent
 *** APSCFG_DEBUG_WIDTH_RINDENT  : size of right message indent
 *** APSCFG_DEBUG_WIDTH_SOFTTAB  : size of soft tab stops (first at LINDENT)
 *** APSCFG_DEBUG_WIDTH_FILENAME : maximum displayed filename length
 *** APSCFG_DEBUG_WIDTH_TOTAL    : total width of formatted messages
 *** APSCFG_DEBUG_MAX_MSG_SIZE   : maximum formatted message size in bytes
 *
 * These control the output from the trace macros.  You can tinker with
 * these to obtain various effects but watch for warnings from debug.c
 * about the size being too small!
 */
#define APSCFG_DEBUG_WIDTH_LINDENT  2
#define APSCFG_DEBUG_WIDTH_RINDENT  2
#define APSCFG_DEBUG_WIDTH_SOFTTAB  4
#define APSCFG_DEBUG_WIDTH_FILENAME 30
#define APSCFG_DEBUG_WIDTH_TOTAL    79
#define APSCFG_DEBUG_MAX_MSG_SIZE   2000

/************************
 *** MEMORY ALLOCATOR ***
 ************************/

/*** APSCFG_MALLOC_DATAALIGN: Specify minimum alignment for reliable/fast
 *                            data access.
 *
 * Tells APS the minimum byte-alignment for a chunk of data.
 * This is used by trackmem.c to ensure that data elements are accessible.
 *
 * Default: sizeof(int) (if not imported from config.h)
 */
#if (APSCFG_MALLOC_DATAALIGN == 0)
#define APSCFG_MALLOC_DATAALIGN SIZEOF_INT
#endif

/*** APSCFG_MALLOC_USERALIGN: Specify minimum alignment for user spaces.
 *                            (Must be at least APSCFG_MALLOC_DATAALIGN)
 *
 * Guarantees that user spaces returned by trackmem.c are aligned to
 * this boundary.  Assumes function specified by APSCFG_MALLOC_ALLOC()
 * ensures that allocations are already pre-aligned to at least this
 * boundary.
 * [Note: may cause massive memory waste if abused]
 *
 * Default: max(APSCFG_MALLOC_DATAALIGN, 16) (if not imported from config.h)
 */
#if (APSCFG_MALLOC_USERALIGN == 0)
#if (APSCFG_MALLOC_DATAALIGN < 16)
#define APSCFG_MALLOC_USERALIGN 16
#else
#define APSCFG_MALLOC_USERALIGN APSCFG_MALLOC_DATAALIGN
#endif
#endif

/*** APSCFG_MALLOC_LIB: Select library to use for malloc purposes
 *   ./configure --malloc-lib [dmalloc|efence]
 *
 * If defined, represents a library which will be linked in to
 * provide memory allocation.  This is helpful for the library's
 * internal memory allocator for detecting conflicting configurations.
 *
 * Recognized:
 *   dmalloc - provides malloc(), calloc(), free(), realloc()
 *   efence  - provides malloc(), calloc(), free(), realloc()
 *   libc6   - provides malloc(), calloc(), free(), realloc(),
 *                      malloc_usable_size()
 *   stdlib  - provides malloc(), calloc(), free(), realloc()
 *
 * Provides:
 *   APSCFG_MALLOC_ALLOC       : function to allocate RAM
 *   APSCFG_MALLOC_CALLOC      : function to allocate zero-filled RAM
 *   APSCFG_MALLOC_FREE        : function to free RAM
 *   APSCFG_MALLOC_REALLOC     : function to reallocate RAM
 *   APSCFG_MALLOC_USABLE_SIZE : function to get size of an allocation
 *
 * Default: stdlib
 */
#ifndef APSCFG_MALLOC_LIB
#define APSCFG_MALLOC_LIB stdlib
#endif
#if (APSCFG_MALLOC_LIB == libc6)
#define APSCFG_MALLOC_USABLE_SIZE(ptrmem) ((size_t)malloc_usable_size(ptrmem))
#else
#undef APSCFG_MALLOC_USABLE_SIZE
#if ((APSCFG_MALLOC_LIB != dmalloc) && \
     (APSCFG_MALLOC_LIB != efence) && \
     (APSCFG_MALLOC_LIB != stdlib))
#warning "Unrecognized memory allocator library in APSCFG_MALLOC_LIB"
#endif
#endif
#define APSCFG_MALLOC_ALLOC(size) ((void *)malloc((size_t)size))
#define APSCFG_MALLOC_CALLOC(size) ((void *)calloc((size_t)size))
#define APSCFG_MALLOC_REALLOC(ptrmem, size) ((void *)realloc(ptrmem, \
    (size_t)size))
#define APSCFG_MALLOC_FREE(ptrmem) (free(ptrmem))


/************************
 *** STRING FUNCTIONS ***
 ************************/

/*** Check strdup()
 *
 * If strdup() is provided, does nothing;
 * Otherwise, defines APSCFG_NEEDS_STRDUP to use the one in utils.c.
 */
#undef APSCFG_NEEDS_STRDUP
#ifndef HAVE_STRDUP
#define APSCFG_NEEDS_STRDUP
#endif

/*** Check strcasecmp() / stricmp()
 *
 * If stricmp() is provided, does nothing;
 * If strcasecmp() is provided, defines a macro for stricmp();
 * Otherwise, defines APSCFG_NEEDS_STRICMP to use the one in utils.c.
 */
#undef APSCFG_NEEDS_STRICMP
#ifndef HAVE_STRICMP
#ifdef HAVE_STRCASECMP
#define stricmp(x, y) strcasecmp(x, y)
#else
#define APSCFG_NEEDS_STRICMP
#endif
#endif

/*** Check strncasecmp() / strnicmp()
 *
 * If strnicmp() is provided, does nothing;
 * If strncasecmp() is provided, defines a macro for strnicmp();
 * Otherwise, defines APSCFG_NEEDS_STRNICMP to use the one in utils.c.
 */
#undef APSCFG_NEEDS_STRNICMP
#ifndef HAVE_STRNICMP
#ifdef HAVE_STRNCASECMP
#define strnicmp(x, y, n) strncasecmp(x, y, n)
#else
#define APSCFG_NEEDS_STRNICMP
#endif
#endif


/********************
 *** GLOBAL PATHS ***
 ********************/

/*** APSCFG_PATH_xxxx_FILE       : absolute path to files
 *** APSCFG_PATH_xxxx_DIR        : absolute path to dirs
 *** APSCFG_PATH_xxxx_RELFILE    : relative path to files
 *** APSCFG_PATH_xxxx_RELDIR     : relative part to dirs
 *** APSCFG_PATH_xxxx_SEARCHDIR  : search directory for files
 *** APSCFG_PATH_xxxx_SEARCHPGM  : search name for program file
 *** APSCFG_PATH_xxxx_SEARCHFILE : search name for file
 *** APSCFG_PATH_xxxx_DEFxxxx    : default name (eg. on failed search)
 *
 * These constants provide a means of configuring default system paths at
 * run-time.
 *
 * Rules:
 *   Dir names never end in "/" (add one if you need to when using the
 *                               constant)
 *   Absolute paths always begin in "/"
 *   Relative paths never begin in "/"
 */

/*** GLOBAL PATHS ***/
/* dir for temp files */
#define APSCFG_PATH_TEMPORARY_DIR \
    "/tmp"

/* dir for process information and management device */
#define APSCFG_PATH_PROC_DIR \
    "/proc"

/* search path for binaries */
#define APSCFG_PATH_DEFAULT_PGM_SEARCHDIR \
    "/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin"

/* search path for files -- no default for now */
#undef APSCFG_PATH_DEFAULT_FILE_SEARCHDIR


/*********************
 *** GLOBAL LIMITS ***
 *********************/

/*** APSCFG_MAX_CONFIG_LINE_SIZE: Specify max length of a config line
 *
 * Maximum length for a line from a human-readable configuration
 * (incl. null)
 */
#define APSCFG_MAX_CONFIG_LINE_SIZE 512

/*** APSCFG_MAX_PRINTER_NAME_SIZE: Specify max length of a printer name
 *
 * Maximum length of an APS printer name (incl. null)
 */
#define APSCFG_MAX_PRINTER_NAME_SIZE 64

/*** APSCFG_MAX_PATH_SIZE: Specify max pathname length
 *
 * Maximum length of a path that we should allow and allocated.  Though
 * the system may in fact support infinite path length, we will only
 * ever support this length internally.
 *
 * Avoid allocating heap memory based on this constant as it can be
 * quite wasteful.
 *
 * Default: determined at configuration time, or 1024
 */
#ifndef APSCFG_MAX_PATH_SIZE
#define APSCFG_MAX_PATH_SIZE 1024
#else
#if (APSCFG_MAX_PATH_SIZE == 0)     /* default */
#undef APSCFG_MAX_PATH_SIZE
#define APSCFG_MAX_PATH_SIZE 1024
#elif ((APSCFG_MAX_PATH_SIZE == -1) || (APSCFG_MAX_PATH_SIZE > 2048))
#undef APSCFG_MAX_PATH_SIZE
#define APSCFG_MAX_PATH_SIZE 2048   /* upper bound */
#elif (APSCFG_MAX_PATH_SIZE < 256)
#undef APSCFG_MAX_PATH_SIZE
#define APSCFG_MAX_PATH_SIZE 256    /* lower bound */
#endif
#endif

/*** APSCFG_MAX_NETWORK_PATH_SIZE: Specify max network path length
 *
 * Maximum length for a network path. (incl. null)
 */
#define APSCFG_MAX_NETWORK_PATH_SIZE (512 + APSCFG_MAX_PATH_SIZE)

/*** APSCFG_MAX_[U]INT_STR_SIZE: Specify max chars in a integer string
 *
 * Maximum number of characters in a string-representation of a native
 * integer w/o a null terminator
 *
 * length = floor(log10(2) * numbits) + 1
 *        = floor(0.301229996 * 8 * numbytes) + 1
 *        = floor(0.301229996 * 2^20 * 8 * numbytes) / 2^20 + 1
 */
/* unsigned */
#define APSCFG_MAX_UINT_STR_SIZE \
    (SIZEOF_INT * 2525223 / 1048576 + 1)
/* signed */
#define APSCFG_MAX_INT_STR_SIZE \
    (1 + APSCFG_MAX_UINT_STR_SIZE)
/* this is the correct definition, but the above one is safer:
   (1 + ((SIZEOF_INT * 8) - 1) * 315653 / 1048576 + 1) */


/***********************
 *** GLOBAL TIMEOUTS ***
 ***********************/

/*** APSCFG_TIMEOUT_xxxx: Specify a timeout in seconds for some operation
 *
 * Timeouts are used to prevent calling applications from hanging if
 * APS must perform some potentially dangerous operation which might
 * hang.
 * This includes, but is not limited to:
 *  - program invocation
 *  - socket connection
 *  - ...?
 *
 * Note: A value of 0 disables a timeout.
 */
#define APSCFG_TIMEOUT_DEFAULT 10


/*******************************
 *** GLOBAL OPTIONS/SETTINGS ***
 *******************************/

/*** APSCFG_COPY_BUFFER_SIZE: Specify size of file copy buffer
 *
 * Used when copying files.
 *
 * Default: 4kb
 */
#define APSCFG_COPY_BUFFER_SIZE 4096

/*** APSCFG_FILE_BUFFER_SIZE: Specify size of file access buffer
 *
 * Used when seeking through files in a linear fashion to extract data.
 * Should not be as large as APSCFG_COPY_BUFFER_SIZE as it may be more
 * wasteful.  Generally this is used to process or build a single record
 * of ascii-text information.  For other tasks, define suitable constants
 * for your module.
 *
 * Default: 256 bytes
 */
#define APSCFG_FILE_BUFFER_SIZE 256

/****************************************
 *** ALL GLOBAL CONFIGURATION MODULES ***
 ****************************************/

/*** CONFIGURATION FILE PATHS ***/
/* base dir for system-wide printer configuration */
#define APSCFG_CONFIG_PATH_PRINTER_SYS_DIR \
    "/etc/printers"

/* base dir for user-local printer configuration
 * -- relative to home directory */
#define APSCFG_CONFIG_PATH_PRINTER_USER_RELDIR \
    ".printers"

/* base dir for system-wide printer meta-configs (.conf files) */
#define APSCFG_CONFIG_PATH_META_SYS_DIR \
    APSCFG_CONFIG_PATH_PRINTER_SYS_DIR

/* base dir for user-local printer meta-configs (.conf files)
 * -- relative to home directory */
#define APSCFG_CONFIG_PATH_META_USER_RELDIR \
    APSCFG_CONFIG_PATH_PRINTER_USER_RELDIR

/* default meta-configuration file suffix */
#define APSCFG_CONFIG_PATH_META_SUFFIX ".conf"

/* location of system's PPD files */
#define APSCFG_CONFIG_PATH_PPD_SYS_DIR \
    APSCFG_CONFIG_PATH_PRINTER_SYS_DIR

/* default ppd file suffix & separator */
#define APSCFG_CONFIG_PATH_PPD_SUFFIX ".ppd"
#define APSCFG_CONFIG_PATH_PPD_SEPARATOR "-"

/* location of system's model database */
#define APSCFG_CONFIG_PATH_MODELDB_SYS_FILE \
    (APSCFG_CONFIG_PATH_PRINTER_SYS_DIR "/models")

/* default test pattern file */
#define APSCFG_CONFIG_PATH_TESTPATTERN_FILE \
    (APSCFG_CONFIG_PATH_PRINTER_SYS_DIR "/testpat.eps")

/* model-probing script */
#define APSCFG_CONFIG_PATH_MODEL_PROBE_FILE \
    (APSCFG_CONFIG_PATH_PRINTER_SYS_DIR "/print_config")

/*** CONFIGURATION TIMEOUTS ***/
/* timeout for print model-probing script */
#define APSCFG_CONFIG_TIMEOUT_MODEL_PROBE 10

/****************************
 *** LPR TRANSPORT MODULE ***
 ****************************/

/*** APSCFG_LPR_BUILD         : compile in LPR Transport
 *   ./configure --[enable/disable]-lpr
 *** APSCFG_LPR_SUPPORT_BSD   : compile in special support for BSD-style LPR
 *** APSCFG_LPR_SUPPORT_LPRNG : compile in special support for LPRNG
 *
 * LPR Transport and all of its components are included by default.  This
 * behaviour may be changed via compile-time options.
 * Excluding the module may cause compatibility issues.
 */
#ifndef APSCFG_LPR_BUILD
#define APSCFG_LPR_BUILD 1
#endif
#define APSCFG_LPR_SUPPORT_BSD 1
#define APSCFG_LPR_SUPPORT_LPRNG 1

/*** APSCFG_LPR_LET_DAEMON_MANAGE_NETWORKS: Let LPD dispatch to net printers?
 *
 * This flag controls whether or not requests for control of an LPD-based
 * network printer will be fielded by the LPR system directly or by a
 * suitable print filter in the output filter chain.
 *
 * Default: FALSE
 */
#ifndef APSCFG_LPR_LET_DAEMON_MANAGE_NETWORKS
#define APSCFG_LPR_LET_DAEMON_MANAGE_NETWORKS 0
#endif

/*** LPR TRANSPORT MODULE PATHS ***/
/* base dir for LPR spool directory */
#define APSCFG_LPR_PATH_SPOOL_DIR \
    "/var/spool/lpd"

/* ouput filter directory */
#define APSCFG_LPR_PATH_FILTER_DIR \
    "/etc/printfilters"

/* master output filter -- copied to spool dir as file "filter" */
#define APSCFG_LPR_PATH_MASTERFILTER_FILE \
    (APSCFG_LPR_PATH_FILTER_DIR "/launch-filter")

/* search path & default location of printcap file */
#define APSCFG_LPR_PATH_PRINTCAP_SEARCHDIR \
    "/etc:/usr/local/etc"
#define APSCFG_LPR_PATH_PRINTCAP_SEARCHFILE \
    "printcap"
#define APSCFG_LPR_PATH_PRINTCAP_DEFFILE \
    "/etc/printcap"

/* search path of LPR binaries */
#define APSCFG_LPR_PATH_LPC_SEARCHPGM \
    "lpc"
#define APSCFG_LPR_PATH_LPD_SEARCHPGM \
    "lpd"
#define APSCFG_LPR_PATH_LPR_SEARCHPGM \
    "lpr"
#define APSCFG_LPR_PATH_LPRM_SEARCHPGM \
    "lprm"
#define APSCFG_LPR_PATH_LPQ_SEARCHPGM \
    "lpq"

/*** LPR TRANSPORT MODULE TIMEOUTS ***/
/* LPC: --- default */
#define APSCFG_LPR_TIMEOUT_LPC_DEFAULT 10
/* LPC: pause */
#define APSCFG_LPR_TIMEOUT_LPC_PAUSE 10
/* LPC: reread */
#define APSCFG_LPR_TIMEOUT_LPC_REREAD 15
/* LPC: restart all */
#define APSCFG_LPR_TIMEOUT_LPC_RESTARTALL 15
/* LPC: resume */
#define APSCFG_LPR_TIMEOUT_LPC_RESUME 10
/* LPC: status */
#define APSCFG_LPR_TIMEOUT_LPC_STATUS 10
/* LPC: stop all */
#define APSCFG_LPR_TIMEOUT_LPC_STOPALL 15
/* LPQ: reading the queue */
#define APSCFG_LPR_TIMEOUT_LPQ_READ 20
/* LPR: dispatch job */
#define APSCFG_LPR_TIMEOUT_LPR_DISPATCH 20
/* LPR: get version info */
#define APSCFG_LPR_TIMEOUT_LPR_VERSION 2
/* LPRM: purge all jobs */
#define APSCFG_LPR_TIMEOUT_LPRM_PURGE 20
/* LPRM: remove job */
#define APSCFG_LPR_TIMEOUT_LPRM_REMOVE 15
/* GS: process file */
#define APSCFG_LPR_TIMEOUT_GS_PROCESS 60 /* too generous? */

/*****************************
 *** CUPS TRANSPORT MODULE ***
 *****************************/

/*** APSCFG_CUPS_BUILD        : compile in CUPS Transport
 *   ./configure --[enable/disable]-cups
 *
 * CUPS Transport and all of its components are included by default.  This
 * behaviour may be changed via compile-time options.
 * Excluding the module may cause compatibility issues.
 *
 * Note: Currently disabled due to deprecated internal support...
 */
#ifndef APSCFG_CUPS_BUILD
#define APSCFG_CUPS_BUILD 0
#endif
#if (APSCFG_CUPS_BUILD)
#warning "CUPS Transport is unavailable"
#undef APSCFG_CUPS_BUILD
#define APSCFG_CUPS_BUILD 0
#endif


/***********************************
 *** HIGH-LEVEL TRANSPORT MODULE ***
 ***********************************/

/*** Tests ***/
#if ((APSCFG_CUPS_BUILD) && (APSCFG_LPR_BUILD))
#error "Config Error: For now, CUPS and LPR are mutually exclusive"
#elif ((! APSCFG_CUPS_BUILD) && (! APSCFG_LPR_BUILD))
#error "Config Error: No transports selected"
#endif

/* specify maximum number of registered transports */
#define APSCFG_TRANSPORT_MAX_TRANSPORTS 1


/************************************
 *** HIGH-LEVEL ATTRIBUTES MODULE ***
 ************************************/

/* maximum number of registered attribute providers */
#define APSCFG_ATTR_MAX_PROVIDERS 3


/*******************************
 *** Unclutter our namespace ***
 *******************************/

#undef HAVE_CONFIG_H
#undef HAVE_STRDUP
#undef HAVE_STRICMP
#undef HAVE_STRCASECMP
#undef HAVE_STRNICMP
#undef HAVE_STRNCASECMP
#undef HAVE_CUPS_CUPS_H
#undef HAVE_PATHCONF
#undef STAT_MACROS_BROKEN


/***************************************
 *** Summary of all provided symbols ***
 ***************************************/

/* Compiler support:
 *   const                                       (<blank> if unsupported)
 *   INLINE                                      (<blank> if disabled)
 *   APSCFG_INLINE                               (bool)
 *   APSCFG_INLINE_KEYWORD                       (always valid if supported)
 *
 * Environment support:
 *   APSCFG_STAT_BROKEN                          (ifdef switch)
 *
 * Debugging:
 *   DEBUG                                       (ifdef switch)
 *   APSCFG_DEBUG                                (bool)
 *   APSCFG_DEBUG_TRACE                          (bool)
 *   APSCFG_DEBUG_PARANOID                       (bool)
 *   APSCFG_DEBUG_DEF_CHANNELS                   (quoted string)
 *   APSCFG_DEBUG_VAR_CHANNELS                   (quoted string)
 *
 * Memory allocator:
 *   APSCFG_MALLOC_LIB                           (unquoted literal)
 *   APSCFG_MALLOC_DATAALIGN                     (unsigned integer)
 *   APSCFG_MALLOC_USERALIGN                     (unsigned integer)
 *   APSCFG_MALLOC_ALLOC()
 *   APSCFG_MALLOC_CALLOC()
 *   APSCFG_MALLOC_REALLOC()
 *   APSCFG_MALLOC_FREE()
 *   APSCFG_MALLOC_USABLE_SIZE()                 (undefined if not supported)
 *
 * String functions:
 *   strdup()
 *   stricmp()
 *   strnicmp()
 *   APSCFG_NEEDS_STRDUP                         (ifdef switch)
 *   APSCFG_NEEDS_STRICMP                        (ifdef switch)
 *   APSCFG_NEEDS_STRNICMP                       (ifdef switch)
 *
 * Global paths:
 *   APSCFG_PATH_TEMPORARY_DIR                   (quoted string)
 *   APSCFG_PATH_PROC_DIR                        (quoted string)
 *   APSCFG_PATH_DEFAULT_PGM_SEARCHDIR           (quoted string)
 *   APSCFG_PATH_DEFAULT_FILE_SEARCHDIR          (quoted string)
 *
 * Global limits:
 *   APSCFG_MAX_CONFIG_LINE_SIZE                 (unsigned integer)
 *   APSCFG_MAX_PRINTER_NAME_SIZE                (unsigned integer)
 *   APSCFG_MAX_PATH_SIZE                        (unsigned integer)
 *   APSCFG_MAX_NETWORK_PATH_SIZE                (unsigned integer)
 *   APSCFG_MAX_UNIT_STR_SIZE                    (unsigned integer)
 *   APSCFG_MAX_INT_STR_SIZE                     (unsigned integer)
 *
 * Global timeouts:
 *   APSCFG_TIMEOUT_DEFAULT                      (unsigned integer)
 *
 * Global options/settings:
 *   APSCFG_COPY_BUFFER_SIZE                     (unsigned integer)
 *   APSCFG_FILE_BUFFER_SIZE                     (unsigned integer)
 *
 * Global config module defaults:
 *   APSCFG_CONFIG_PATH_PRINTER_SYS_DIR          (quoted string)
 *   APSCFG_CONFIG_PATH_PRINTER_USER_RELDIR      (quoted string)
 *   APSCFG_CONFIG_PATH_META_SYS_DIR             (quoted string)
 *   APSCFG_CONFIG_PATH_META_USER_RELDIR         (quoted string)
 *   APSCFG_CONFIG_PATH_PPD_SYS_DIR              (quoted string)
 *   APSCFG_CONFIG_PATH_PPD_SUFFIX               (quoted string)
 *   APSCFG_CONFIG_PATH_PPD_SEPARATOR            (quoted string)
 *   APSCFG_CONFIG_PATH_MODELDB_SYS_FILE         (quoted string)
 *   APSCFG_CONFIG_PATH_TESTPATTERN_FILE         (quoted string)
 *   APSCFG_CONFIG_PATH_MODEL_PROBE_FILE         (quoted string)
 *   APSCFG_CONFIG_TIMEOUT_MODEL_PROBE           (unsigned integer)
 *
 * LPR Transport:
 *   APSCFG_LPR_BUILD                            (bool)
 *   APSCFG_LPR_SUPPORT_BSD                      (bool)
 *   APSCFG_LPR_SUPPORT_LPRNG                    (bool)
 *   APSCFG_LPR_LET_DAEMON_MANAGE_NETWORKS       (bool)
 *   APSCFG_LPR_PATH_SPOOL_DIR                   (quoted string)
 *   APSCFG_LPR_PATH_FILTER_DIR                  (quoted string)
 *   APSCFG_LPR_PATH_MASTERFILTER_FILE           (quoted string)
 *   APSCFG_LPR_PATH_PRINTCAP_SEARCHDIR          (quoted string)
 *   APSCFG_LPR_PATH_PRINTCAP_SEARCHFILE         (quoted string)
 *   APSCFG_LPR_PATH_PRINTCAP_DEFFILE            (quoted string)
 *   APSCFG_LPR_PATH_LPC_SEARCHPGM               (quoted string)
 *   APSCFG_LPR_PATH_LPD_SEARCHPGM               (quoted string)
 *   APSCFG_LPR_PATH_LPR_SEARCHPGM               (quoted string)
 *   APSCFG_LPR_PATH_LPRM_SEARCHPGM              (quoted string)
 *   APSCFG_LPR_PATH_LPQ_SEARCHPGM               (quoted string)
 *   APSCFG_LPR_TIMEOUT_LPC_DEFAULT              (unsigned integer)
 *   APSCFG_LPR_TIMEOUT_LPC_PAUSE                (unsigned integer)
 *   APSCFG_LPR_TIMEOUT_LPC_REREAD               (unsigned integer)
 *   APSCFG_LPR_TIMEOUT_LPC_RESTARTALL           (unsigned integer)
 *   APSCFG_LPR_TIMEOUT_LPC_RESUME               (unsigned integer)
 *   APSCFG_LPR_TIMEOUT_LPC_STATUS               (unsigned integer)
 *   APSCFG_LPR_TIMEOUT_LPC_STOPALL              (unsigned integer)
 *   APSCFG_LPR_TIMEOUT_LPQ_READ                 (unsigned integer)
 *   APSCFG_LPR_TIMEOUT_LPR_DISPATCH             (unsigned integer)
 *   APSCFG_LPR_TIMEOUT_LPR_VERSION              (unsigned integer)
 *   APSCFG_LPR_TIMEOUT_LPRM_PURGE               (unsigned integer)
 *   APSCFG_LPR_TIMEOUT_LPRM_REMOVE              (unsigned integer)
 *   APSCFG_LPR_TIMEOUT_GS_PROCESS               (unsigned integer)
 *
 * CUPS Transport:
 *   APSCFG_CUPS_BUILD                           (bool)
 *
 * High-level Attributes:
 *   APSCFG_ATTR_MAX_PROVIDERS                   (unsigned integer)
 *
 * Values retained from config.h:
 *   SIZEOF_CHAR
 *   SIZEOF_INT
 *   SIZEOF_VOID_P
 *   SIZEOF_DOUBLE
 *
 * Package information
 *   PACKAGE                                    (quoted string)
 *   VERSION                                    (quoted string)
 */