/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: attribute.h
 *
 * Description: Implementation of an attribute, which is a type of
 *              APS object property that includes information such as
 *              the range of possible values for the setting, translated
 *              text to be displayed to the user, etc. Attribute
 *              properties are the basis of a JobAttributes object,
 *              which stores properties pertaining to a current or
 *              future print jobs.
 */

#ifndef ATTRIBUTE_H
#define ATTRIBUTE_H

/* Forward type declarations. */
typedef struct Attribute_ Attribute;

#include "attrprovider.h"

/* Definition of a full-fledged "attribute" property. */
struct Attribute_ {
    AttrProvider *provider;
    char *translatedName;
    char *mainData;
    char *translatedData;
    Aps_AttrType type;
    double minSetting;
    double maxSetting;
    Aps_AttrOption *options;
    int numOptions;
    char *setting;
};

/* Functions that manipulate an individual attribute. */
Aps_Result AttrCreate(Attribute **attribute, AttrProvider *provider);
void AttrDelete(Attribute *attribute);
Aps_Result AttrCopyContents(Attribute *dest, const Attribute *src);
void AttrRemoveAllOptions(Attribute *attribute);
Aps_Result AttrAddOption(Attribute *attribute, const char *optionID,
                         const char *translatedName, const char *value);
Aps_Result AttrSetSetting(Attribute *attribute, const char *setting);

#endif /* ATTRIBUTE_H */
