/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: generalpurpose.c
 *
 * Description: General purpose library-wide APIs.
 *
 * N.B. Instantiates interfaces needed for TrackArray's.
 */

#include <stdlib.h>

#include "aps.h"
#include "apsinternal.h"

DEBUG_CHANNEL_DEFAULT(utils)

/* Implement all the TrackArray template types we use
 * -- declare in apsinternal.h */
#if (! APSCFG_INLINE)
TrackArray_Implement(PtrChar)
TrackArray_Implement(PtrQuickJobInfo)
TrackArray_Implement(PtrQuickPrinterQInfo)
TrackArray_Implement(PtrAttrOption)
TrackArray_Implement(PtrResolution)
TrackArray_Implement(PtrFontInfo)
TrackArray_Implement(PtrPageSize)
TrackArrayIndirect_Implement(QuickJobInfo, PtrQuickJobInfo)
TrackArrayIndirect_Implement(QuickPrinterQInfo, PtrQuickPrinterQInfo)
TrackArrayIndirect_Implement(AttrOption, PtrAttrOption)
TrackArrayIndirect_Implement(Resolution, PtrResolution)
TrackArrayIndirect_Implement(FontInfo, PtrFontInfo)
TrackArrayIndirect_Implement(PageSize, PtrPageSize)
#endif

/* ---------------------------------------------------------------------------
 * Aps_ReleaseBuffer()
 *
 * Deallocates a memory buffer that another APS function allocated in order
 * to pass data back to the client program.
 *
 * Parameters: A pointer to a buffer that was allocated by a call to another
 *             APS function.
 *
 *     Return: APS_SUCESS on success, or a standard Aps_Result code.
 */
Aps_Result Aps_ReleaseBuffer(const void *buffer) /* FIXME! const void??? */
{
    /* Check parameter validity. */
    if (buffer == NULL) {
        return APS_INVALID_PARAM;
    }

    /* Deallocate the memory. */
    TrackMemFree((void *)buffer);

    return APS_SUCCESS;
}