/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: LprTransport.h
 *
 * Description: Definitions specifically to the LPR transport
 *              abstraction layer.
 *
 */

#ifndef LPRTRANSPORT_H
#define LPRTRANSPORT_H

typedef struct LprTransport_ LprTransport;
typedef struct LprJobContext_ LprJobContext;
typedef struct LprScanTable_ LprScanTable;
typedef struct LprScanMap_ LprScanMap;

#include <aps.h>
#include "printer.h"
#include "transport.h"
#include "readwriteprintcap.h"
#include "lprdetect.h"
#include "job.h"

Transport *LprCreateTransport(void);

/* LPR transport object
 */
struct LprTransport_ {
    Transport baseClass;

    /* LprTransport specific data */
    time_t lastPrintcapInfoUpdate; /* Time of last update */
    Aps_Printcap_Info **apsPrintcapInfo; /* Will be NULL if invalid */
    int numberOfPrintcapEntries; /* Will be 0 if invalid */

    /* Configuration settings (autodetect) */
    LprImplInfo *config;
};

/* LPR transport Job storage
 */
struct LprJobContext_ {
    Job *queueNext;   /* next job in list */
    Job *queuePrev;   /* previous job in list */
    int locked;       /* LprTransport has a lock on the job */
    int match;        /* temp: match # in mapping table */
};

/* Structures used by code which builds mappings between
 * Aps_QuickJobInfo's which are read and the cache list
 */
struct LprScanMap_ {
    Aps_QuickJobInfo *info;
    Job              *job;
    int               closeness;
};
struct LprScanTable_ {
    TrackArrayIndirect_QuickJobInfo array; /* used to build the list */
    Aps_PrinterStatus       printerStatus; /* stored printer status */
    int                     size;    /* number of info structs */
    struct LprScanMap_      map[0];  /* mappings */
};

/* Things needed in lprtransport.c */
void LprNotifyPrintcapWasModified(Transport * thisBase, FILE *fh, int fd);
Aps_Printcap_Info *LprPrintcapLocateByName(LprTransport *lpr,
    const char *name);
int LprPrintcapTestByName(Aps_Printcap_Info *pi, const char *name);
int LprComparePrinterNames(LprTransport *lpr, const char *name1,
   const char *name2);

/* Support code protos in lprtransportsup.c */
Aps_PrinterStatus LprAnyGetQueueStatus(LprTransport *lpr, Printer *printer);
Aps_Result LprBSDReadQueue(LprTransport *lpr,
    Aps_QuickJobInfo *protoinfo, TrackArrayIndirect_QuickJobInfo *array);
Aps_Result LprBSDGetQueueStatus(LprTransport *lpr, Aps_QuickJobInfo *info);
Aps_Result LprNGReadQueue(LprTransport *lpr,
    Aps_QuickJobInfo *protoinfo, TrackArrayIndirect_QuickJobInfo *array);
Aps_Result LprNGGetQueueStatus(LprTransport *lpr, Aps_QuickJobInfo *info);

#endif /* !LPRTRANSPORT_H */
