/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: Printer.h
 *
 * Description: Definition of the Printer structure, which
 *              contains the internal APS information associated with
 *              an Aps_PrinterHandle.
 */

#ifndef PRINTER_H
#define PRINTER_H

/* Forward type defintion that allows us to refer to an
 * APS_PRINTER_OBJECT before we've defined its contents.
 */
typedef struct Printer_ Printer;

#include "jobattributes.h"
#include "object.h"
#include "transport.h"

/* Definition of table of functions that operate on a printer object.
 */
typedef struct {
    void (*Destructor) (Printer * this);
} PrinterVtbl;

/* Definition of the Printer structure itself. There is exactly
 * one instance of this structure for each Aps_PrinterHandle
 * returned to the client application.
 */
struct Printer_ {
    ApsObject baseClass;

    /* C++ like virtual function table of methods that operate on
     * generic Printer instances.
     */
    PrinterVtbl *vtbl;

    /* Basic printer attributes. */
    char *name;
    JobAttributes *defaultJobAttributes;
    Transport *transport;
    Aps_ModelHandle model;
};

Printer *PrinterGetPtrFromHandle(Aps_PrinterHandle handle);
Aps_PrinterHandle PrinterGetHandleFromPtr(Printer * printer);
Aps_Result PrinterInitialize(Printer * printer, const char *name,
                             void *transport);
void PrinterDelete(Printer * printer);

#endif /* !PRINTER_H */
