/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: printerdefault.c
 *
 * Description: APIs for default printer tagging.
 *
 */

#include "aps.h"
#include "apsinternal.h"
#include "transport.h"

/* ---------------------------------------------------------------------------
 * Aps_PrinterIsDefault()
 *
 * Determines whether or not a particular printer is the default printer.
 *
 * Parameters: printer   - A handle to the printer in question.
 *
 *             isDefault - The address of an int to be set to TRUE if this
 *                         is the default printer, FALSE otherwise.
 *
 *     Return: A standard APS_RESULT code indicating success or reason for
 *             failure.
 */
Aps_Result Aps_PrinterIsDefault(Aps_PrinterHandle handle, int *isDefault)
{
    Printer *printer;

    /* Check for reasonable parameter values. */
    if (handle == NULL)
        return APS_INVALID_PARAM;

    if ((printer = PrinterGetPtrFromHandle(handle))== NULL)
        return APS_INVALID_HANDLE;

    /* Dispatch to the transport for processing */
    ASSERT(printer->transport);
    return printer->transport->vtbl->PrinterIsDefault(printer->transport,
        handle, isDefault);
}

/* ---------------------------------------------------------------------------
 * Aps_PrinterSetAsDefault()
 *
 * Changes the printer that will be used by default if the user doesn't
 * choose a specific printer to print to.
 *
 * Parameters: handle - A handle to the printer to set as default.
 *
 *     Return: A standard APS_RESULT code indicating success or reason for
 *             failure.
 */
Aps_Result Aps_PrinterSetAsDefault(Aps_PrinterHandle handle)
{
    Printer *printer;

    /* Check for reasonable parameter values. */
    if (handle == NULL)
        return APS_INVALID_PARAM;

    if ((printer = PrinterGetPtrFromHandle(handle))== NULL)
        return APS_INVALID_HANDLE;

    /* Dispatch to the transport for processing */
    ASSERT(printer->transport);
    return printer->transport->vtbl->PrinterSetAsDefault(printer->transport,
        handle);
}
