/* 
 * APS Application Print Services library
 * (C) Copyright 1999 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: testaps.h
 *
 * Description: Header file for class declaration of TestAps
 */
#include <aps.h>

#ifndef APS_TEST_H
#define APS_TEST_H

class QListBox;
class QPushButton;
class QLineEdit;
class QMultiLineEdit;
class QLabel;
#include <qwidget.h>

class TestAps: public QWidget
{
    Q_OBJECT 
public :
    TestAps();
    ~TestAps();
protected :
    QListBox *listLibNames; // Shows the library names
    QPushButton *pbExecute; // Pushbutton for Execute
    QPushButton *pbExit; 	 // Pushbutton for Exit
    QLineEdit   *editInput1;// Input parameter1
    QLineEdit   *editInput2;// Input parameter2
    QLineEdit   *editInput3;// Input parameterr3
    QLineEdit   *editInput4;// Input parameter4
    QMultiLineEdit  *editInput5;// Input parameter 5 
    QLineEdit   *editOutput1;// Output parameter1
    QLineEdit   *editOutput2;// Output parameter2
    QLineEdit   *editOutput3;// Output parameter3
    QLineEdit   *editResult;// Test result 
    QLabel      *labelInput1;// label for input parameter 1
    QLabel      *labelInput2;// label for input parameter 2
    QLabel      *labelInput3;// label for input parameter 3
    QLabel      *labelInput4;// label for input parameter 4
    QLabel      *labelInput5;// label for input parameter 5
    QLabel      *labelOutput1;//label for Output parameter 1
    QLabel      *labelOutput2;//label for Output parameter 2
    QLabel      *labelOutput3;//label for Output parameter 3
    
    QLabel      *labelResult;// label for Result
    int selItemPos ; 	// index of the selected item 
    int numCalls ; 	// index of the selected item 
protected slots :
    void SlotHighlightedItem(int);
    void Quit();	
    void Execute();	
private	:
    void RunDispatchJob(void);
    void RunPrinterSetAsDefault(void);
    void RunPrinterIsDefault(void);
    void RunAddPrinter(void);
    void RunPrinterRemove(void);
    void RunBasicPrinting(void);
    void RunReleaseHandle(void);
    void RunGetResultText(void);
    void RunOpenDefaultPrinter(void);
    void RunGetPrinters(void);
    void RunOpenPrinter(void);
    void RunGetDefaultJobSettings(void);
    void RunSetDefaultJobSettings(void);
    void RunGetProperty(void);
    void RunSetProperty(void);
    void RunStartJob(void);
    void RunGetJobSettings(void);
    void RunWrite(void);
    void RunGetJobState(void);
    void RunEndJob(void);
    void RunGetPPDFilename(void);
    void RunCancelJob(void);
    void RunGetPrinterName(void);
    void RunPrinterRename(void);
    void RunPrinterSetMaxJobSize(void);
    void RunPrinterGetMaxJobSize(void);
    void RunPrinterSetConfigFlags(void);
    void RunPrinterGetConfigFlags(void);
    void RunPrinterGetConnectInfo(void);
    void RunPrinterSetConnectInfo(void);
    void SetResultEditBox(int);
    void SetJobStateEditBox(Aps_JobStatus);
    void MessageBox(char *, char *);
    void SetPrevHandles(int);
private :
    // Added on 11/19
    Aps_Result	lastResult; 
                    //Stores the Result code returned from last APS call executed
    Aps_PrinterHandle  lastPrinterHandle;
                 //Stores the Printer Handle returned from last APS call executed
    Aps_JobHandle  lastJobHandle;
                 //Stores the Job Handle returned from last APS call executed
    Aps_JobAttrHandle  lastJobAttrHandle;
                 //Stores the Job Handle returned from last APS call executed

};
#endif
