// scheddlg.C
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 199

//
// 1999-11-21-Espen Sand <espen@kde.org>:
// Changed to KDialogBase
//


#include <sched.h>

#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qstring.h>

#include <kapp.h>
#include <kmessagebox.h>
#include <klocale.h>

#include "buttongroup.h"
#include "dialogs.h"
#include "locale.h"
#include "scheddlg.h"

SchedDialog::SchedDialog(int policy, int prio)
  : KDialogBase( kapp->mainWidget(), 0, true, i18n("Change scheduling"), 
		 Ok|Cancel, Ok )
{
  QWidget *page = new QWidget( this );
  setMainWidget( page );

  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );
    
  ButtonGroup *group = new ButtonGroup( i18n("Scheduling Policy"), page );
  connect( group,  SIGNAL(clicked(int)), this, SLOT(button_clicked(int)) );
  topLayout->addWidget( group );

  QVBoxLayout *vl = new QVBoxLayout( group, spacingHint(), spacingHint() );
  vl->addSpacing( fontMetrics().lineSpacing() );
  rb_other = new QRadioButton(i18n("SCHED_OTHER (time-sharing)"), group );
  rb_fifo  = new QRadioButton(i18n("SCHED_FIFO (real-time)"), group );
  rb_rr    = new QRadioButton(i18n("SCHED_RR (real-time)"), group );

  vl->addWidget( rb_other );
  vl->addWidget( rb_fifo );
  vl->addWidget( rb_rr );

  int active = 0;
  switch(policy) 
  {
    case SCHED_OTHER:
      active = 0; 
    break;
    case SCHED_FIFO:
      active = 1; 
    break;
    case SCHED_RR:
      active = 2; 
    break;
  }
  ((QRadioButton *)(group->find(active)))->setChecked(TRUE);
  out_policy = policy;
  out_prio = prio;


  QHBoxLayout *hl = new QHBoxLayout();
  topLayout->addLayout(hl);
    
  label = new QLabel(i18n("Priority (1-99):"), page);
  hl->addWidget(label);

  lined = new QLineEdit(page);
  lined->setMinimumWidth( fontMetrics().maxWidth()*10 );
  lined->setText( QString().setNum(prio) );
  hl->addWidget(lined);
  button_clicked(active);

  topLayout->addSpacing( spacingHint() );
}





void SchedDialog::slotOK( void )
{
  if(rb_rr->isChecked())
    out_policy = SCHED_RR;
  else if(rb_fifo->isChecked())
    out_policy = SCHED_FIFO;
  else
    out_policy = SCHED_OTHER;
  QString s(lined->text());
  bool ok;
  out_prio = s.toInt(&ok);
  if(out_policy != SCHED_OTHER && (!ok || out_prio < 1 || out_prio > 99)) 
  {
    QString msg = i18n("The priority must be in the range 1..99");
    KMessageBox::error( this, msg );
  } 
  else
  {
    accept();
  }
}

void SchedDialog::button_clicked(int id)
{
  if(id == 0) 
  {
    label->setEnabled(FALSE);
    lined->setEnabled(FALSE);
  } 
  else 
  {
    QString s(lined->text());
    bool ok;
    int n = s.toInt(&ok);
    if(ok && n == 0)
      lined->setText("1");
    label->setEnabled(TRUE);
    lined->setEnabled(TRUE);
    
    lined->setFocus();
    lined->selectAll();
  }
}



