
package kdocDocIter;

use strict;

=head1 kdocDocIter -- Iteration over DocNode children

=head2 TextIter -- Iterate over doc data (non-attribute children).

	"$s..." means subref.

	$..S and $...E means start and end, P means "print".

	so: $sS means doc start, $sTextP means print text.

	all subrefs receive ( node, text ) as params (text should be ignored
	if it is not pertinent to the type).

	it is safe to leave any subref undefined.

=cut

sub TextIter
{
	my ( $docNode, $sS, $sE, $sTextP, $sRefP, $sSectP, $sPreP, $sImageP,
		$sParaP, $sListS, $sListE, $sListP ) = @_;
	return if !defined $docNode;

	my $text = $docNode->{Text};
	return if !defined $text || $#$text < 0;

	my $lastType = "";

	$sS->( $docNode ) if defined $sS;

	foreach my $tnode ( @$text ) {
		my $type = $tnode->{NodeType};
		my $name = $tnode->{astNodeName};
		
		if ( $lastType eq "ListItem" && $type ne $lastType ) {
			$sListE->( $tnode, $name ) if defined $sListE;
		}

		if ( $type eq "DocText" ) {
			$sTextP->( $tnode, $name ) if defined $sTextP;
		}
		elsif ( $type eq "Pre" ) {
			$sPreP->( $tnode, $name, $tnode->{Desc} ) if defined $sPreP;
		}
		elsif ( $type eq "Ref" ) {
			$sRefP->( $tnode, $name, $tnode->{Ref} ) if defined $sRefP;
		}
		elsif ( $type eq "DocSection" ) {
			$sSectP->( $tnode, $name ) if defined $sSectP;
		}
		elsif ( $type eq "Image" ) {
			$sImageP->( $tnode, $name, $tnode->{Path} ) if defined $sImageP;
		}
		elsif( $type eq "ParaBreak" ) {
			$sParaP->( $tnode, $name ) if defined $sParaP;
		}
		elsif( $type eq "ListItem" ) {
			if ( $lastType ne "ListItem" ) {
				$sListS->( $tnode, $name ) if defined $sListS;
			}
			$sListP->( $tnode, $name ) if defined $sListP;
		}
		else {
#			warn "Unknown DocNode:Text node: $name ($type)\n";
		}

		$lastType = $type;
	}

	if ( $lastType eq "ListItem" ) {
		$sListE->( undef, undef ) if defined $sListE;
	}

	$sE->( $docNode ) if defined $sE;
}

sub ParamIter
{
	my ( $docNode, $sS, $sE, $sP ) = @_;
	return unless defined $docNode && defined $docNode->{Text};

	my @params = ();
	kdocAstUtil::findNodes( \@params, $docNode->{Text}, "NodeType", "Param" );
	return unless $#params >= 0;

	$sS->() if defined $sS;

	foreach my $param ( @params ) {
		$sP->( $param->{Name}, $param->{astNodeName} ) if defined $sP;
	}

	$sE->() if defined $sE;
}

1;
