#line 2 "scanner.cc"
/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /home/kde/koffice/lib/koscript/scanner.cc,v 1.4 2000/09/25 14:15:38 torben Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <unistd.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int yy_size_t;


struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO(( FILE *input_file ));

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *yy_str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t ));
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)


#define YY_USES_REJECT

#define yywrap() 1
#define YY_SKIP_YYWRAP
typedef unsigned char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef int yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yy_fatal_error YY_PROTO(( yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 91
#define YY_END_OF_BUFFER 92
static yyconst short int yy_acclist[318] =
    {   0,
       92,   90,   91,    1,   90,   91,    2,   91,    1,   90,
       91,   23,   90,   91,   90,   91,   90,   91,   47,   90,
       91,   32,   90,   91,   37,   90,   91,   90,   91,   17,
       90,   91,   18,   90,   91,   30,   90,   91,   28,   90,
       91,   90,   91,   29,   90,   91,   43,   90,   91,   31,
       90,   91,   86,   90,   91,   85,   90,   91,   19,   90,
       91,   20,   90,   91,   41,   90,   91,   24,   90,   91,
       42,   90,   91,   78,   90,   91,   78,   90,   91,   78,
       90,   91,   15,   90,   91,   16,   90,   91,   36,   90,
       91,   78,   90,   91,   78,   90,   91,   78,   90,   91,

       78,   90,   91,   78,   90,   91,   78,   90,   91,   78,
       90,   91,   78,   90,   91,   78,   90,   91,   78,   90,
       91,   78,   90,   91,   78,   90,   91,   78,   90,   91,
       13,   90,   91,   35,   90,   91,   14,   90,   91,   33,
       90,   91,   22,   89,    5,    4,   46,   38,   75,   44,
       83,   76,   45,    3,16392,   86,   87,   85,   77,   27,
       39,   25,   21,   40,   26,    9,   78,   78,   78,   78,
       78,   78,   78,   78,   61,   78,   78,   78,   78,   78,
       78,   63,   78,   78,   58,   78,   78,   78,   78,   78,
       78,   78,   78,   78,   78,   34,    4,    9,   88,16392,

        3, 8200, 8200,    3,    3,   82,   81,   87,   82,   78,
       78,   78,   78,   78,   78,   78,   78,   78,   78,   62,
       78,   78,   78,   78,   78,   59,   78,   78,   78,   78,
       78,   78,   71,   78,   69,   78,   78,   10,   84,   82,
       81,   82,    7,   78,   50,   78,   55,   78,   78,   78,
       78,   64,   78,   57,   78,   78,   78,   74,   78,   78,
       78,   65,   78,   78,   78,   78,   78,   52,   78,   78,
       82,   80,   79,   79,   82,   12,   49,   78,   72,   78,
       48,   78,   78,   78,   78,   78,   70,   78,   73,   78,
       78,   78,   78,   60,   78,   82,    6,   78,   51,   78,

       78,   68,   78,   67,   78,   53,   78,   54,   78,   11,
       80,   81,   56,   78,   66,   78,   79
    } ;

static yyconst short int yy_accept[270] =
    {   0,
        1,    1,    1,    2,    4,    7,    9,   12,   15,   17,
       19,   22,   25,   28,   30,   33,   36,   39,   42,   44,
       47,   50,   53,   56,   59,   62,   65,   68,   71,   74,
       77,   80,   83,   86,   89,   92,   95,   98,  101,  104,
      107,  110,  113,  116,  119,  122,  125,  128,  131,  134,
      137,  140,  143,  143,  143,  144,  144,  145,  145,  145,
      146,  147,  147,  148,  149,  149,  149,  150,  151,  152,
      153,  154,  154,  156,  156,  156,  156,  157,  157,  157,
      158,  158,  158,  159,  160,  161,  162,  163,  164,  164,
      165,  166,  166,  168,  169,  170,  171,  172,  173,  174,

      175,  177,  178,  179,  180,  181,  182,  184,  185,  187,
      188,  189,  190,  191,  192,  193,  194,  195,  196,  197,
      197,  197,  197,  197,  198,  199,  200,  200,  200,  200,
      201,  203,  204,  205,  206,  206,  207,  207,  208,  209,
      209,  210,  210,  210,  210,  210,  211,  212,  213,  214,
      215,  216,  217,  218,  219,  220,  222,  223,  224,  225,
      226,  228,  229,  230,  231,  232,  233,  235,  237,  238,
      238,  239,  239,  239,  239,  239,  239,  240,  240,  240,
      241,  241,  242,  242,  243,  243,  244,  244,  244,  244,
      244,  245,  247,  249,  250,  251,  252,  254,  256,  257,

      258,  260,  261,  262,  264,  265,  266,  267,  268,  270,
      271,  271,  271,  271,  271,  271,  272,  272,  273,  274,
      276,  276,  276,  276,  276,  277,  279,  281,  283,  284,
      285,  286,  287,  289,  291,  292,  293,  294,  296,  296,
      296,  296,  297,  297,  297,  297,  298,  298,  299,  301,
      302,  304,  306,  308,  310,  310,  311,  311,  311,  313,
      313,  315,  317,  317,  317,  317,  318,  318,  318
    } ;

static yyconst int yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    5,    6,    7,    8,    9,   10,   11,   12,
       13,   14,   15,   16,   17,   18,   19,   20,   21,   21,
       21,   21,   21,   21,   21,   22,   22,   23,   24,   25,
       26,   27,   28,    1,   29,   30,   30,   30,   31,   32,
       33,   33,   33,   33,   33,   34,   33,   33,   33,   33,
       33,   35,   36,   37,   38,   33,   33,   39,   33,   33,
       40,   41,   42,   43,   44,    1,   45,   46,   47,   48,

       49,   50,   33,   51,   52,   33,   33,   53,   54,   55,
       56,   57,   33,   58,   59,   60,   61,   62,   63,   64,
       65,   33,   66,   67,   68,   69,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst int yy_meta[70] =
    {   0,
        1,    2,    2,    3,    3,    4,    1,    5,    1,    1,
        6,    7,    1,    1,    1,    1,    1,    7,    1,    8,
        8,    9,   10,    1,    1,    1,    1,    4,   11,   11,
       11,   11,   12,   12,   12,   12,   12,   12,   13,    1,
        4,    1,    1,   14,   15,   15,   11,   11,   11,   15,
       12,   12,   12,   12,   13,   12,   12,   13,   12,   13,
       12,   13,   12,   13,   12,    1,    1,    1,    1
    } ;

static yyconst short int yy_base[291] =
    {   0,
        0,    0,  749, 1007, 1007, 1007,  741,  719,   64,   68,
      700, 1007,  733,  698, 1007, 1007, 1007,   57,   54,   60,
       58,   62,  102,   78,  715, 1007,   62,   58,   64,  108,
      127,   66, 1007, 1007, 1007,    0,   63,   97,   56,  105,
      110,   92,   64,  109,  107,   85,  128,  111, 1007,  670,
     1007, 1007,  731,  727, 1007,  104, 1007,  148,  731, 1007,
      730,  164, 1007, 1007,  721,  154, 1007, 1007,  157, 1007,
     1007,  140,  218,  728,  175,  169,  137,  268,  194,  328,
      288,  182,    0, 1007, 1007, 1007, 1007, 1007,  286, 1007,
     1007,  274,  293,  701,    0,   68,  154,  262,  263,  270,

      700,  271,  273,  272,   86,  126,  699,  274,  282,  165,
      275,  277,  283,  288,  290,  307,  294,  295, 1007,  719,
      319,  345,    0,  723,  333, 1007,  350,    0,  367,  721,
      389, 1007,    0,    0,  359,  389,  401,  413,    0,  419,
      405,  424,  344,  705,  713,  440,  169,  297,  413,  315,
      378,  338,  417,  418,  390,  419,  421,  422,  340,  424,
      691,  423,  430,  431,  435,  432,  690,  689,  436,  449,
      465,  484,  520,  456,  706,  476,  479,  712,  488,  496,
      513,  491,  501,  526,  461, 1007,  712,  488,  706,  516,
      524,  684,  683,  503,  502,  510,  682,  677,  527,  474,

      676,  485,  529,  672,  445,  486,  530,  531,  671,  534,
      690,  558,  566,  667,  559,  572,  564,  575,  580,  604,
      563,  568,  674,  590,  593,  639,  631,  613,  576,  587,
      544,  577,  605,  604,  588,  589,  590,  602,  622,  624,
      618,  630,  642,  634,  628, 1007,  625,  598,  491,  619,
      444,  184,  181,  178,  645,  651,  654,  660,  663,  666,
      171,   75,  669,  672,  691,  692,  682, 1007,  739,  754,
      769,  774,  789,  804,  817,  825,  836,  848,  863,  875,
      888,  896,  904,  919,  929,  940,  950,  965,  976,  991
    } ;

static yyconst short int yy_def[291] =
    {   0,
      268,    1,  268,  268,  268,  268,  269,  268,  270,  271,
      272,  268,  268,  273,  268,  268,  268,  268,  268,  268,
      268,  274,  269,   23,  268,  268,  268,  268,  268,  275,
      275,   31,  268,  268,  268,  276,   31,   31,   31,   31,
       31,   31,   31,   31,   31,   31,   31,   31,  268,  268,
      268,  268,  269,  277,  268,  270,  268,  278,  271,  268,
      279,  272,  268,  268,  268,  280,  268,  268,  268,  268,
      268,  274,  268,  274,  269,  268,   23,   23,  269,  269,
      269,  268,   24,  268,  268,  268,  268,  268,  268,  268,
      268,  268,  281,   31,  276,   31,   31,   31,   31,   31,

       31,   31,   31,   31,   31,   31,   31,   31,   31,   31,
       31,   31,   31,   31,   31,   31,   31,   31,  268,  277,
      277,  270,  282,  279,  268,  268,  268,  283,  268,  284,
       73,  268,   73,  131,  269,  268,  268,  269,   80,  269,
      268,  268,  285,  268,  286,  281,   31,   31,   31,   31,
       31,   31,   31,   31,   31,   31,   31,   31,   31,   31,
       31,   31,   31,   31,   31,   31,   31,   31,   31,  268,
      268,  270,  270,  268,  287,  268,  268,  284,  269,  268,
      268,  268,  269,  268,  285,  268,  285,  288,  286,  286,
       31,   31,   31,   31,   31,   31,   31,   31,   31,   31,

       31,   31,   31,   31,   31,   31,   31,   31,   31,   31,
      289,  270,  270,  268,   23,  268,  268,  268,   24,  268,
      288,  290,  288,  268,  268,   31,   31,   31,   31,   31,
       31,   31,   31,   31,   31,   31,   31,   31,  289,  289,
      268,  268,  268,  268,  290,  268,  290,   31,   31,   31,
       31,   31,   31,   31,  268,  268,  268,  268,  268,  268,
       31,   31,  268,  268,  268,  268,  268,    0,  268,  268,
      268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
      268,  268,  268,  268,  268,  268,  268,  268,  268,  268
    } ;

static yyconst short int yy_nxt[1077] =
    {   0,
        4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
       14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
       24,   24,   25,   26,   27,   28,   29,    4,   30,   30,
       30,   31,   30,   30,   30,   30,   32,   30,   30,   33,
        4,   34,   35,   36,   30,   30,   37,   38,   39,   40,
       30,   41,   30,   42,   30,   43,   30,   44,   45,   46,
       30,   47,   48,   30,   30,   49,   50,   51,   52,   57,
       60,   67,   61,   69,   69,   69,   70,   69,   69,   69,
       73,   81,   68,   88,   94,   71,   85,   86,   87,   90,
       91,   94,   94,   82,   94,   82,   94,   83,   83,   83,

       97,  147,   74,   94,   58,   75,   54,   98,  102,   57,
      103,   53,   54,   94,   94,   92,   53,   76,   99,   76,
       94,   77,   77,   78,  111,   94,   89,   93,   93,   93,
       53,   54,   79,   94,   92,   94,  110,   94,   94,   94,
       80,   53,  116,  156,   58,  100,   93,   93,   93,  104,
       79,   95,  101,  112,   94,   96,   94,  113,  130,  107,
      105,  118,  106,  108,  109,   80,  114,  122,  122,  115,
       95,   92,  117,  127,  127,   53,   69,   69,   69,   54,
       74,  157,   94,  125,  125,  125,  123,  129,  136,  136,
      136,  148,  128,   94,  135,  135,  135,   94,   54,   94,

       53,  141,  141,  141,  191,  129,   94,  268,  137,   94,
      137,  123,   94,  138,  138,  138,  160,  128,  131,  131,
      132,  133,  131,  131,  131,  131,  131,  131,  131,  134,
      131,  131,  131,  131,  131,  134,  131,  134,  134,  134,
      131,  131,  131,  131,  131,  131,  134,  134,  134,  134,
      134,  134,  134,  134,  134,  134,  134,  131,  131,  131,
      131,  134,  134,  134,  134,  134,  134,  134,  134,  134,
      134,  134,  134,  134,  134,  134,  134,  134,  134,  134,
      134,  134,  134,  131,  131,  131,  131,   78,   78,  142,
       94,   94,   54,  125,  125,  125,   53,   54,   94,   94,

       94,   94,   94,   94,  143,   94,   53,  140,  140,  140,
       94,   94,   93,   93,   93,  145,   94,  151,   94,  152,
      149,  150,   94,   94,  155,   94,  170,  192,  162,  153,
      158,   53,   54,  154,  161,   94,   95,  159,  171,  171,
      171,  165,  163,   94,  144,  164,  169,  139,  139,  139,
       57,  168,  125,  125,  125,  145,  139,  139,  139,  139,
      126,  194,  186,   54,  172,  172,   94,  166,   94,  174,
      174,  167,  139,  139,  139,  139,  139,  139,  179,  179,
      179,  176,  196,  176,  187,   58,  177,  177,  177,  134,
      134,  268,  134,  134,  134,  134,  134,  134,  134,  134,

      203,  134,  134,  134,  134,  134,   94,  134,  180,  180,
      180,  134,  134,  134,  134,  134,  134,   54,   94,  181,
      182,  182,  182,   54,  184,  184,  184,  142,  134,  134,
      134,  134,  138,  138,  138,  181,  195,  181,  183,  183,
      183,   94,  143,   53,   54,   94,   94,   94,  199,   94,
       94,   94,   94,  181,  134,  134,  134,  134,   94,   94,
       94,  193,  268,   94,   94,  197,  126,  200,  171,  171,
      171,  198,   94,   94,  201,   65,   65,  202,  204,  186,
      209,  205,  144,   95,  171,  171,  171,  211,  210,   57,
      206,  207,   54,  234,  208,  177,  177,  177,  177,  177,

      177,  187,   94,  212,  212,   54,  222,  215,  215,  215,
      182,  182,  182,   94,   94,  216,  216,  216,  231,   94,
      219,  219,  219,  224,   58,   57,  181,  217,  223,  217,
       94,   94,  218,  218,  218,  225,  225,  225,   94,  213,
      213,  213,  232,  235,  181,  220,  220,  220,  213,  213,
      213,  213,   94,  227,  226,   94,  181,   94,   94,   94,
       58,  228,   94,   57,  213,  213,  213,  213,  213,  213,
      229,   57,   94,  230,  181,  241,  236,  237,   53,   53,
       53,  222,  238,  218,  218,  218,  246,   76,  233,   76,
      250,  242,  242,  242,  218,  218,  218,   53,   58,   53,

       53,   53,  243,  223,   94,   94,   58,  244,  247,  225,
      225,  225,  225,  225,  225,   94,   94,   94,   94,   82,
      243,   82,   53,  242,  242,  242,   94,  268,  248,  268,
       94,  255,   94,   94,  243,  249,  251,  257,  257,  257,
      254,   94,  252,  256,  256,  256,  246,   94,  253,  242,
      242,  242,  243,  260,  260,  260,  258,  261,  258,   94,
      181,  259,  259,  259,  256,  256,  256,   94,  247,  262,
      256,  256,  256,  263,  263,  263,  268,  126,  181,  259,
      259,  259,  259,  259,  259,  264,  264,  264,  265,  265,
      265,  266,  266,  266,  241,  244,  137,  239,  137,   94,

       94,  182,  182,  182,   94,   94,   76,   82,   76,   82,
       94,   94,   94,  268,  268,  178,  126,   94,   94,   94,
      189,  267,  267,  188,  178,   60,  268,   94,   94,   94,
      268,  126,   60,   60,  120,   54,  119,   84,   66,  267,
      267,   53,   64,   63,   55,   54,   53,   53,  268,   53,
       53,   53,  268,   53,   56,  268,   56,   56,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   56,   56,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   62,   62,   62,   62,   62,   65,
      268,   65,   65,   65,  268,   65,   65,   65,   65,   65,

       65,   65,   65,   65,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72,   72,   72,   72,   72,   94,
      268,   94,  268,  268,   94,   94,  268,   94,   94,   94,
       94,   94,   95,   95,  268,   95,   95,   95,   95,   95,
      121,  268,  268,  268,  268,  268,  121,  121,  121,  268,
      121,   56,  268,   56,  268,   56,  268,  268,  268,  268,
       56,  268,   56,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,   65,  268,
       65,  268,   65,  268,  268,  268,  268,   65,  268,   65,
      146,  268,  268,  268,  268,  146,  146,  146,  146,  146,

      146,  146,  146,  173,  173,  268,  173,  268,  268,  268,
      173,  175,  175,  268,  175,  268,  268,  268,  175,  132,
      132,  132,  132,  132,  132,  268,  268,  268,  132,  185,
      185,  185,  185,  185,  185,  185,  185,  185,  185,  185,
      185,  185,  185,  185,  190,  268,  268,  268,  268,  268,
      190,  190,  190,  268,  190,  214,  268,  214,  214,  268,
      214,  268,  268,  268,  214,  221,  221,  221,  221,  221,
      221,  221,  221,  221,  221,  221,  221,  221,  221,  221,
      240,  268,  268,  268,  268,  268,  240,  240,  240,  268,
      240,  245,  245,  245,  245,  245,  245,  245,  245,  245,

      245,  245,  245,  245,  245,  245,    3,  268,  268,  268,
      268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
      268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
      268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
      268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
      268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
      268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
      268,  268,  268,  268,  268,  268
    } ;

static yyconst short int yy_chk[1077] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    9,
       10,   18,   10,   19,   19,   19,   20,   21,   21,   21,
       22,   24,   18,   28,   39,   20,   27,   27,   27,   29,
       29,   37,   43,   24,   32,   24,   96,   24,   24,   24,

       32,   96,   22,  262,    9,   23,   23,   37,   39,   56,
       39,   30,   30,   46,  105,   30,   24,   23,   37,   23,
       42,   23,   23,   23,   43,   38,   28,   30,   30,   30,
       31,   31,   23,   40,   31,   45,   42,   44,   41,   48,
       23,   24,   46,  105,   56,   38,   31,   31,   31,   40,
       23,   30,   38,   44,  106,   31,   47,   44,   72,   41,
       40,   48,   40,   41,   41,   23,   45,   58,   58,   45,
       31,   62,   47,   66,   66,   77,   69,   69,   69,   75,
       72,  106,   97,   62,   62,   62,   58,   69,   76,   76,
       76,   97,   66,  110,   75,   75,   75,  147,   79,  261,

       77,   82,   82,   82,  147,   69,  254,   62,   79,  253,
       79,   58,  252,   79,   79,   79,  110,   66,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   78,   78,   89,
       98,   99,   81,   92,   92,   92,   93,   93,  100,  102,

      104,  103,  108,  111,   89,  112,   78,   81,   81,   81,
      109,  113,   93,   93,   93,   93,  114,   99,  115,  100,
       98,   98,  117,  118,  104,  148,  121,  148,  112,  102,
      108,   78,   80,  103,  111,  116,   93,  109,  121,  121,
      121,  115,  113,  150,   89,  114,  118,   80,   80,   80,
      122,  117,  125,  125,  125,  125,   80,   80,   80,   80,
      127,  150,  143,  135,  122,  122,  152,  116,  159,  127,
      127,  116,   80,   80,   80,   80,   80,   80,  135,  135,
      135,  129,  152,  129,  143,  122,  129,  129,  129,  131,
      131,  131,  131,  131,  131,  131,  131,  131,  131,  131,

      159,  131,  131,  131,  131,  131,  151,  131,  136,  136,
      136,  131,  131,  131,  131,  131,  131,  138,  155,  136,
      137,  137,  137,  140,  141,  141,  141,  142,  131,  131,
      131,  131,  138,  138,  138,  141,  151,  136,  140,  140,
      140,  149,  142,  146,  146,  153,  154,  156,  155,  157,
      158,  162,  160,  141,  131,  131,  131,  131,  163,  164,
      166,  149,  146,  165,  169,  153,  174,  156,  170,  170,
      170,  154,  251,  205,  157,  174,  174,  158,  160,  185,
      166,  162,  142,  146,  171,  171,  171,  171,  169,  172,
      163,  164,  179,  205,  165,  176,  176,  176,  177,  177,

      177,  185,  200,  172,  172,  183,  188,  179,  179,  179,
      182,  182,  182,  202,  206,  180,  180,  180,  200,  249,
      183,  183,  183,  190,  172,  173,  180,  181,  188,  181,
      195,  194,  181,  181,  181,  190,  190,  190,  196,  173,
      173,  173,  202,  206,  180,  184,  184,  184,  173,  173,
      173,  173,  191,  194,  191,  199,  184,  203,  207,  208,
      173,  195,  210,  212,  173,  173,  173,  173,  173,  173,
      196,  213,  231,  199,  184,  216,  207,  208,  215,  215,
      215,  221,  210,  217,  217,  217,  222,  216,  203,  216,
      231,  216,  216,  216,  218,  218,  218,  215,  212,  219,

      219,  219,  216,  221,  229,  232,  213,  220,  222,  224,
      224,  224,  225,  225,  225,  230,  235,  236,  237,  220,
      216,  220,  215,  220,  220,  220,  248,  247,  229,  239,
      238,  240,  234,  233,  220,  230,  232,  241,  241,  241,
      237,  228,  235,  240,  240,  240,  245,  250,  236,  242,
      242,  242,  220,  244,  244,  244,  243,  248,  243,  227,
      242,  243,  243,  243,  255,  255,  255,  226,  245,  250,
      256,  256,  256,  257,  257,  257,  223,  214,  242,  258,
      258,  258,  259,  259,  259,  260,  260,  260,  263,  263,
      263,  264,  264,  264,  265,  266,  267,  211,  267,  209,

      204,  267,  267,  267,  201,  198,  265,  266,  265,  266,
      197,  193,  192,  189,  187,  178,  175,  168,  167,  161,
      145,  265,  266,  144,  130,  124,  120,  107,  101,   94,
       74,   65,   61,   59,   54,   53,   50,   25,   14,  265,
      266,  269,   13,   11,    8,    7,  269,  269,    3,  269,
      269,  269,    0,  269,  270,    0,  270,  270,  270,  270,
      270,  270,  270,  270,  270,  270,  270,  270,  270,  271,
      271,  271,  271,  271,  271,  271,  271,  271,  271,  271,
      271,  271,  271,  271,  272,  272,  272,  272,  272,  273,
        0,  273,  273,  273,    0,  273,  273,  273,  273,  273,

      273,  273,  273,  273,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  275,
        0,  275,    0,    0,  275,  275,    0,  275,  275,  275,
      275,  275,  276,  276,    0,  276,  276,  276,  276,  276,
      277,    0,    0,    0,    0,    0,  277,  277,  277,    0,
      277,  278,    0,  278,    0,  278,    0,    0,    0,    0,
      278,    0,  278,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  280,    0,
      280,    0,  280,    0,    0,    0,    0,  280,    0,  280,
      281,    0,    0,    0,    0,  281,  281,  281,  281,  281,

      281,  281,  281,  282,  282,    0,  282,    0,    0,    0,
      282,  283,  283,    0,  283,    0,    0,    0,  283,  284,
      284,  284,  284,  284,  284,    0,    0,    0,  284,  285,
      285,  285,  285,  285,  285,  285,  285,  285,  285,  285,
      285,  285,  285,  285,  286,    0,    0,    0,    0,    0,
      286,  286,  286,    0,  286,  287,    0,  287,  287,    0,
      287,    0,    0,    0,  287,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      289,    0,    0,    0,    0,    0,  289,  289,  289,    0,
      289,  290,  290,  290,  290,  290,  290,  290,  290,  290,

      290,  290,  290,  290,  290,  290,  268,  268,  268,  268,
      268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
      268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
      268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
      268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
      268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
      268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
      268,  268,  268,  268,  268,  268
    } ;

static yy_state_type yy_state_buf[YY_BUF_SIZE + 2], *yy_state_ptr;
static char *yy_full_match;
static int yy_lp;
static int yy_looking_for_trail_begin = 0;
static int yy_full_lp;
static int *yy_full_state;
#define YY_TRAILING_MASK 0x2000
#define YY_TRAILING_HEAD_MASK 0x4000
#define REJECT \
{ \
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */ \
yy_cp = yy_full_match; /* restore poss. backed-over text */ \
yy_lp = yy_full_lp; /* restore orig. accepting pos. */ \
yy_state_ptr = yy_full_state; /* restore orig. state */ \
yy_current_state = *yy_state_ptr; /* restore curr. state */ \
++yy_lp; \
goto find_rule; \
}
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "scanner.ll"
#define INITIAL 0
#line 2 "scanner.ll"

#define YY_NO_UNPUT
#include <stdlib.h>
#include <ctype.h>

#include "koscript_parsenode.h"
#include "koscript_types.h"
#include "koscript_synext.h"
#include "koscript_locale.h"

#include <klocale.h>

#ifndef KDE_USE_FINAL
#include "yacc.cc.h"
#endif

extern int idl_line_no;

static bool s_kspread;
KLocale* s_koscript_locale = 0;
static KLocale* s_defaultLocale = 0;

#include <qstring.h>

static KScript::Long ascii_to_longlong( long base, const char *s )
{
  KScript::Long ll = 0;
  while( *s != '\0' ) {
    char c = *s++;
    if( c >= 'a' )
      c -= 'a' - 'A';
    c -= '0';
    if( c > 9 )
      c -= 'A' - '0' - 10;
    ll = ll * base + c;
  }
  return ll;
}

static KScript::Double ascii_to_longdouble (const char *s)
{
  KScript::Double d;
#ifdef HAVE_SCANF_LF
  sscanf (s, "%Lf", &d);
#else
  /*
   * this is only an approximation and will probably break fixed<>
   * parameter calculation on systems where
   * sizeof(double) < sizeof(long double). but fortunately all
   * systems where scanf("%Lf") is known to be broken (Linux/Alpha
   * and HPUX) have sizeof(double) == sizeof(long double).
   */
  d = strtod (s, NULL);
#endif
  return d;
}

static char translate_char( const char *s )
{
  char c = *s++;

  if( c != '\\' )
    return c;
  c = *s++;
  switch( c ) {
  case 'n':
    return '\n';
  case 't':
    return '\t';
  case 'v':
    return '\v';
  case 'b':
    return '\b';
  case 'r':
    return '\r';
  case 'f':
    return '\f';
  case 'a':
    return '\a';
  case '\\':
    return '\\';
  case '?':
    return '\?';
  case '\'':
    return '\'';
  case '"':
    return '"';
  case 'x':
  case 'X':
    return (char) ascii_to_longlong( 16, s );
  default:
    // Gotta be an octal
    return (char) ascii_to_longlong( 8, s );
  }
}

static QChar translate_unichar( const QChar *s )
{
  QChar c = *s++;

  if( c != '\\' )
    return c;
  c = *s++;
  switch( c.latin1() ) {
  case 'n':
    return '\n';
  case 't':
    return '\t';
  case 'v':
    return '\v';
  case 'b':
    return '\b';
  case 'r':
    return '\r';
  case 'f':
    return '\f';
  case 'a':
    return '\a';
  case '\\':
    return '\\';
  case '?':
    return '\?';
  case '\'':
    return '\'';
  case '"':
    return '"';
  default:
    return c;
  }
}

static void translate_string( QString& str )
{
	int pos = 0;
	while( ( pos = str.find( '\\', pos ) ) != -1 )
	{
		QChar ch = translate_unichar( str.unicode() + pos );
		str.replace( pos, 2, &ch, 1 );
	}
}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#line 892 "scanner.cc"

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PROTO(( yyconst char * ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

YY_DECL
	{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;

#line 182 "scanner.ll"


#line 1046 "scanner.cc"

	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start;
		yy_state_ptr = yy_state_buf;
		*yy_state_ptr++ = yy_current_state;
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 269 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			*yy_state_ptr++ = yy_current_state;
			++yy_cp;
			}
		while ( yy_current_state != 268 );

yy_find_action:
		yy_current_state = *--yy_state_ptr;
		yy_lp = yy_accept[yy_current_state];
find_rule: /* we branch to this label when backing up */
		for ( ; ; ) /* until we find what rule we matched */
			{
			if ( yy_lp && yy_lp < yy_accept[yy_current_state + 1] )
				{
				yy_act = yy_acclist[yy_lp];
				if ( yy_act & YY_TRAILING_HEAD_MASK ||
				     yy_looking_for_trail_begin )
					{
					if ( yy_act == yy_looking_for_trail_begin )
						{
						yy_looking_for_trail_begin = 0;
						yy_act &= ~YY_TRAILING_HEAD_MASK;
						break;
						}
					}
				else if ( yy_act & YY_TRAILING_MASK )
					{
					yy_looking_for_trail_begin = yy_act & ~YY_TRAILING_MASK;
					yy_looking_for_trail_begin |= YY_TRAILING_HEAD_MASK;
					}
				else
					{
					yy_full_match = yy_cp;
					yy_full_state = yy_state_ptr;
					yy_full_lp = yy_lp;
					break;
					}
				++yy_lp;
				goto find_rule;
				}
			--yy_cp;
			yy_current_state = *--yy_state_ptr;
			yy_lp = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
YY_RULE_SETUP
#line 184 "scanner.ll"
;
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 185 "scanner.ll"
{ idl_line_no++; return T_SEMICOLON; }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 186 "scanner.ll"
;
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 187 "scanner.ll"
;
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 188 "scanner.ll"
;
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 190 "scanner.ll"
{
						  const char *c = yytext + 2;
						  while( isspace( *c ) ) ++c;
						  ++c; ++c;
			 			  yylval._str = new QString( c );
						  yylval._str->truncate( yylval._str->length() - 1 );
						  return T_SUBST;
						}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 198 "scanner.ll"
{
						  const char *c = yytext + 2;
						  while( isspace( *c ) ) ++c;
						  ++c;
			 			  yylval._str = new QString( c );
						  yylval._str->truncate( yylval._str->length() - 1 );
						  return T_MATCH;
						}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 206 "scanner.ll"
{
			 			  yylval._str = new QString( yytext + 1 );
						  yylval._str->truncate( yylval._str->length() - 1 );
						  return T_MATCH_LINE;
						}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 212 "scanner.ll"
{
			  if ( !s_kspread )
			  {
			  	yylval.ident = new QString( yytext );
			  	return T_IDENTIFIER;
			  }
                          yylval._str = new QString( yytext );
			  return T_CELL;
		       };
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 222 "scanner.ll"
{
			  if ( !s_kspread )
			  {
			  	yylval.ident = new QString( yytext );
			  	return T_IDENTIFIER;
			  }
                          yylval._str = new QString( yytext );
			  return T_CELL;
		       };
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 232 "scanner.ll"
{
			  if ( !s_kspread )
			  {
			  	yylval.ident = new QString( yytext );
			  	return T_IDENTIFIER;
			  }
                          yylval._str = new QString( yytext );
			  return T_RANGE;
		       };
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 242 "scanner.ll"
{
			  if ( !s_kspread )
			  {
			  	yylval.ident = new QString( yytext );
			  	return T_IDENTIFIER;
			  }
                          yylval._str = new QString( yytext );
			  return T_RANGE;
		       };
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 252 "scanner.ll"
return T_LEFT_CURLY_BRACKET;
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 253 "scanner.ll"
return T_RIGHT_CURLY_BRACKET;
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 254 "scanner.ll"
return T_LEFT_SQUARE_BRACKET;
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 255 "scanner.ll"
return T_RIGHT_SQUARE_BRACKET;
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 256 "scanner.ll"
return T_LEFT_PARANTHESIS;
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 257 "scanner.ll"
return T_RIGHT_PARANTHESIS;
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 258 "scanner.ll"
return T_COLON;
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 259 "scanner.ll"
return T_COMMA;
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 260 "scanner.ll"
return T_EQUAL;
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 261 "scanner.ll"
return T_NOTEQUAL;
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 262 "scanner.ll"
return T_NOT;
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 263 "scanner.ll"
return T_ASSIGN;
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 264 "scanner.ll"
return T_INPUT;
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 265 "scanner.ll"
return T_SHIFTRIGHT;
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 266 "scanner.ll"
return T_SHIFTLEFT;
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 267 "scanner.ll"
return T_PLUS_SIGN;
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 268 "scanner.ll"
return T_MINUS_SIGN;
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 269 "scanner.ll"
return T_ASTERISK;
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 270 "scanner.ll"
return T_SOLIDUS;
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 271 "scanner.ll"
return T_PERCENT_SIGN;
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 272 "scanner.ll"
return T_TILDE;
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 273 "scanner.ll"
return T_OR;
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 274 "scanner.ll"
return T_VERTICAL_LINE;
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 275 "scanner.ll"
return T_CIRCUMFLEX;
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 276 "scanner.ll"
return T_AMPERSAND;
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 277 "scanner.ll"
return T_AND;
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 278 "scanner.ll"
return T_LESS_OR_EQUAL;
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 279 "scanner.ll"
return T_GREATER_OR_EQUAL;
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 280 "scanner.ll"
return T_LESS_THAN_SIGN;
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 281 "scanner.ll"
return T_GREATER_THAN_SIGN;
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 282 "scanner.ll"
return T_MEMBER;
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 283 "scanner.ll"
return T_PLUS_ASSIGN;
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 284 "scanner.ll"
return T_MINUS_ASSIGN;
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 285 "scanner.ll"
return T_LINE;
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 286 "scanner.ll"
return T_DOLLAR;
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 288 "scanner.ll"
return T_CONST;
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 289 "scanner.ll"
return T_FALSE;
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 290 "scanner.ll"
return T_TRUE;
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 291 "scanner.ll"
return T_FALSE;
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 292 "scanner.ll"
return T_TRUE;
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 293 "scanner.ll"
return T_STRUCT;
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 294 "scanner.ll"
return T_SWITCH;
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 295 "scanner.ll"
return T_CASE;
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 296 "scanner.ll"
return T_DEFAULT;
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 297 "scanner.ll"
return T_ENUM;
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 298 "scanner.ll"
return T_IN;
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 299 "scanner.ll"
return T_OUT;
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 300 "scanner.ll"
return T_WHILE;
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 301 "scanner.ll"
return T_DO;
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 302 "scanner.ll"
return T_FOR;
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 303 "scanner.ll"
{
				if ( !s_kspread )
					return T_IF;
			  	yylval.ident = new QString( yytext );
			  	return T_IDENTIFIER;
			}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 309 "scanner.ll"
return T_ELSE;
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 310 "scanner.ll"
return T_MAIN;
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 311 "scanner.ll"
return T_FOREACH;
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 312 "scanner.ll"
return T_RETURN;
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 313 "scanner.ll"
return T_IMPORT;
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 314 "scanner.ll"
return T_VAR;
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 315 "scanner.ll"
return T_INOUT;
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 316 "scanner.ll"
return T_TRY;
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 317 "scanner.ll"
return T_CATCH;
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 318 "scanner.ll"
return T_RAISE;
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 319 "scanner.ll"
return T_FROM;
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 321 "scanner.ll"
return T_INCR;
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 322 "scanner.ll"
return T_DECR;
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 323 "scanner.ll"
return T_SCOPE;
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 327 "scanner.ll"
{
			  yylval.ident = new QString( yytext );
			  return T_IDENTIFIER;
			}
	YY_BREAK
case 79:
#line 332 "scanner.ll"
case 80:
#line 333 "scanner.ll"
case 81:
#line 334 "scanner.ll"
case 82:
#line 335 "scanner.ll"
case 83:
#line 336 "scanner.ll"
case 84:
YY_RULE_SETUP
#line 336 "scanner.ll"
{
			  QString s( yytext );
			  bool ok = TRUE;
                          double f = s_koscript_locale->readNumber( s, &ok );
			  // if ( !ok )
			  //	f = s.toDouble( &ok );
			  if ( !ok )
				return T_UNKNOWN;
			  int i = (int)f;
			  if ( i == f )
			  {
			      yylval._int = i;
			      return T_INTEGER_LITERAL;
		  	  }
			  yylval._float = f;
			  return T_FLOATING_PT_LITERAL;
			}
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 353 "scanner.ll"
{
			  yylval._int = ascii_to_longlong( 10, yytext );
			  return T_INTEGER_LITERAL;
			}
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 357 "scanner.ll"
{
			  yylval._int = ascii_to_longlong( 8, yytext );
			  return T_INTEGER_LITERAL;
			}
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 361 "scanner.ll"
{
			  yylval._int = ascii_to_longlong( 16, yytext + 2 );
			  return T_INTEGER_LITERAL;
			}
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 365 "scanner.ll"
{
                          QCString s( yytext );
	                  s = s.mid( 1, s.length() - 2 );
			  yylval._char = translate_char( s );
			  return T_CHARACTER_LITERAL;
			}
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 371 "scanner.ll"
{
                          QString s( yytext );
                          yylval._str = new QString( s.mid( 1, s.length() - 2 ) );
			  if ( yylval._str->isNull() )
				*(yylval._str) = "";
			  translate_string( *(yylval._str) );
			  return T_STRING_LITERAL;
			}
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 379 "scanner.ll"
{
                          return T_UNKNOWN;
                        }
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 383 "scanner.ll"
ECHO;
	YY_BREAK
#line 1687 "scanner.cc"
			case YY_STATE_EOF(INITIAL):
				yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */


/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()
	{
	register char *dest = yy_current_buffer->yy_ch_buf;
	register char *source = yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_current_buffer->yy_n_chars = yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_realloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );

		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state()
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = yy_start;
	yy_state_ptr = yy_state_buf;
	*yy_state_ptr++ = yy_current_state;

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 269 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		*yy_state_ptr++ = yy_current_state;
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
yy_state_type yy_current_state;
#endif
	{
	register int yy_is_jam;

	register YY_CHAR yy_c = 1;
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 269 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 268);
	if ( ! yy_is_jam )
		*yy_state_ptr++ = yy_current_state;

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void yyunput( int c, register char *yy_bp )
#else
static void yyunput( c, yy_bp )
int c;
register char *yy_bp;
#endif
	{
	register char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yy_n_chars + 2;
		register char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		register char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_current_buffer->yy_n_chars =
			yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yy_c_buf_p - yytext_ptr;
			++yy_c_buf_p;

			switch ( yy_get_next_buffer() )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						return EOF;

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;


	return c;
	}


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}


#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
extern int isatty YY_PROTO(( int ));
#endif
#endif

#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void yy_flush_buffer( YY_BUFFER_STATE b )
#else
void yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer( char *base, yy_size_t size )
#else
YY_BUFFER_STATE yy_scan_buffer( base, size )
char *base;
yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string( yyconst char *yy_str )
#else
YY_BUFFER_STATE yy_scan_string( yy_str )
yyconst char *yy_str;
#endif
	{
	int len;
	for ( len = 0; yy_str[len]; ++len )
		;

	return yy_scan_bytes( yy_str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes( yyconst char *bytes, int len )
#else
YY_BUFFER_STATE yy_scan_bytes( bytes, len )
yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void yy_push_state( int new_state )
#else
static void yy_push_state( new_state )
int new_state;
#endif
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_realloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void yy_fatal_error( yyconst char msg[] )
#else
static void yy_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int yy_flex_strlen( yyconst char *s )
#else
static int yy_flex_strlen( s )
yyconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_realloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_realloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif
#line 383 "scanner.ll"


void kscriptInitFlex( const char *_code, int extension, KLocale* locale )
{
   s_koscript_locale = locale;
   if ( !s_koscript_locale )
   {
	if ( !s_defaultLocale )
		s_defaultLocale = new KSLocale;
       s_koscript_locale = s_defaultLocale;
   }
   if ( extension == KSCRIPT_EXTENSION_KSPREAD )
	s_kspread = TRUE;
   else
	s_kspread = FALSE;
   yy_switch_to_buffer( yy_scan_string( _code ) );
}

void kscriptInitFlex( int extension, KLocale* locale )
{
   s_koscript_locale = locale;
   if ( !s_koscript_locale )
   {
	if ( !s_defaultLocale )
		s_defaultLocale = new KSLocale;
       s_koscript_locale = s_defaultLocale;
   }
   if ( extension == KSCRIPT_EXTENSION_KSPREAD )
	s_kspread = TRUE;
   else
	s_kspread = FALSE;
}
