#include "AddRCPT.moc"
#include "MailValidator.h"
#include <qwidget.h>
#include <qlabel.h>
#include <klocale.h>
#include <qtooltip.h>
#include <kapp.h>

AddRCPT::AddRCPT(QWidget * parent, char * wname): QWidget(parent, wname)
{
	int y;
	this->setCaption(i18n("Add recipient for upload-notification"));
	resize(320,80);
	setFixedSize(320,80);
	email=new InputCtl(i18n("&Address:"),0,this);
	email->setGeometry(5,5,width()-10,email->height());
	MailValidator *v=new MailValidator(0,0);
	email->setValidator(v);
	y=5+email->height()+5;
	ok=new QPushButton(i18n("&OK"),this);
	ok->setAutoDefault(true);
	ok->setDefault(true);
	ok->setGeometry(5,y,this->width()/2-10,ok->height());
	connect(ok,SIGNAL(clicked()),SLOT(okButtonPressed()));
	cancel=new QPushButton(i18n("&Cancel"),this);
	connect(cancel,SIGNAL(clicked()),SLOT(cancelButtonPressed()));
	cancel->setGeometry(this->width()/2+5,y,this->width()/2-10,cancel->height());
	show();
}
AddRCPT::~AddRCPT()
{
	delete email;
	delete ok;
	delete cancel;
}
void AddRCPT::okButtonPressed()
{
	QString f=email->text();
	if(f!=QString::null)
		emit RCPTAdded(f);
	delete this;
}
void AddRCPT::cancelButtonPressed()
{
	delete this;
}
