#include "kcontrol.moc"
#include <mainwidget.h>
#include <ui.h>
#include <kglobal.h>
#include <klocale.h>
#include <qlayout.h>

KControl::KControl(QWidget *parent, const char *name)
  : KCModule(parent, name)
{
	QVBoxLayout *layout=new QVBoxLayout(this);
	m=new MainWidget(this, name);
	layout->addWidget(m);
	connect(m, SIGNAL(configChanged()), SLOT(configChanged()));
}

void KControl::load()
{
	m->load();
}

void KControl::save()
{
	m->save();
}

void KControl::defaults()
{
	m->defaults();
}

void KControl::reset()
{
	m->reset();
}

void KControl::configChanged() // SLOT
{
	emit changed(true);
}

extern "C"
{
  KCModule *create_lilo(QWidget *parent, const char *name)
  {
    KGlobal::locale()->insertCatalogue("kcmlilo");
    return new KControl(parent, name);
  };
}

