#include "ksvlookandfeel.h"

#include <qlabel.h>
#include <qlayout.h>

#include <kdialog.h>
#include <kfontdialog.h>

/* 
 *  Constructs a KSVLookAndFeel which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
KSVLookAndFeel::KSVLookAndFeel( QWidget* parent,  const char* name, WFlags fl )
    : LookAndFeel( parent, name, fl )
{
  mTopLayout->setSpacing (KDialog::spacingHint());
  mColorGrid->setSpacing (KDialog::spacingHint());
}

/*  
 *  Destroys the object and frees any allocated resources
 */
KSVLookAndFeel::~KSVLookAndFeel()
{
    // no need to delete child widgets, Qt does it all for us
}

/* 
 * protected slot
 */
void KSVLookAndFeel::chooseNumberFont()
{
  KFontDialog::getFont (mNumberFont, false, this);
  setNumberFont (mNumberFont);
}

/* 
 * protected slot
 */
void KSVLookAndFeel::chooseServiceFont()
{
  KFontDialog::getFont (mServiceFont, false, this);
  setServiceFont (mServiceFont);
}

void KSVLookAndFeel::setServiceFont (const QFont& font)
{
  mServiceFontPreview->setFont(font);
  mServiceFontPreview->setText(font.family() + " " + QString::number(font.pointSize()));

  mServiceFont = font;
}

void KSVLookAndFeel::setNumberFont (const QFont& font)
{  
  mNumberFontPreview->setFont(font);
  mNumberFontPreview->setText(font.family() + " " + QString::number(font.pointSize()));

  mNumberFont = font;
}

#include "lookandfeelconfig.moc"
#include "ksvlookandfeel.moc"
