/***************************************************************************
                            Connection.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class provides a simple means for IPC between two applications
 via a pipe.
 It handles a queue of commands to be sent, and has a internal signal
 called after a command has been sent, to send the next one (FIFO).
     
 @short 
 This class provides a simple means for IPC between two applications
 via a pipe.
*/
public class Connection extends QObject  {
	protected Connection(Class dummy){super((Class) null);}

	private native void newConnection();
	public Connection() {
		super((Class) null);
		newConnection();
	}
	protected native void finalize() throws InternalError;
	public native void init( KSocket sock);
	public native void connect( QObject receiver, String member);
	public native void connect();
	public native void close();
	public native int fd_from();
	public native int fd_to();
	public native void init( int fd_in, int fd_out);
	public native boolean inited();
	public native void send( int cmd, byte[] arg1);
	public native void send( int cmd);
	public native boolean sendnow( int _cmd, byte[] data);

/** 
 Receive data

*/
	public native int read( int[] _cmd, byte[] arg1);

/** 
 Don't handle incoming data until resumed
         
*/
	public native void suspend();

/** 
 Resume handling of incoming data
         
*/
	public native void resume();

/** 
 Returns status of connection
         
*/
	public native boolean suspended();
	public native void queueOnly( boolean queue);
	protected native void dequeue();
}

/** Override these methods in subclasses of Connection to customise event handling behaviour */
interface ConnectionEventHandling {
	void childEvent(QChildEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

