/***************************************************************************
                            DCOPObject.java -  description
                             -------------------
    begin                : Sun May  6 15:32:21 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May  6 15:32:21 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Provides an interface for receiving DCOP messages.

 This class provides an interface for receiving DCOP messages.  To use it,
 simply multiply-inherit from DCOPObject and from some other class, and
 then implement the {@link DCOPObject#process} method.  Because this method is
 pure virtual, you <code>must</code> implement the method.

 @author Preston Brown <pbrown@kde.org>, Matthias Ettrich <ettrich@kde.org>
 
 @short 
 Provides an interface for receiving DCOP messages.
*/
public class  DCOPObject implements QtSupport, DCOPObjectInterface {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected DCOPObject(Class dummy){}


/** 
 Creates a {@link DCOPObject} and calculates the object id
 using its physical memory address.
   
*/
	private native void newDCOPObject();
	public DCOPObject() {
		newDCOPObject();
	}

/** 
 Creates a {@link DCOPObject} and calculates the object id
 using {@link QObject#name}.
   
*/
	private native void newDCOPObject( QObject obj);
	public DCOPObject( QObject obj) {
		newDCOPObject( obj);
	}

/** 
 Creates a {@link DCOPObject} with object Id <code>objId.</code>
   
*/
	private native void newDCOPObject( String objId);
	public DCOPObject( String objId) {
		newDCOPObject( objId);
	}

/** 
 Destroys the {@link DCOPObject} and removes it from the map
 of known objects.
   
*/
	protected native void finalize() throws InternalError;
	public native String objId();

/** 
 Dispatches a message.

 Usually you want to use an IDL
 compiler to automatically generate an implementation for
 this function.

 If this function returns <code>false</code>, then {@link #processDynamic}
 is called.

 Note to implementators: remember to call the baseclasses
 implementation.

*/
	public native boolean process( String fun, byte[] data, String replyType, byte[] replyData);

/** 
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #process} but
 you still want to dispatch some functions dynamically.
 Dynamically means that methods may appear and vanish
 during runtime.

*/
	public native boolean processDynamic( String fun, byte[] data, String replyType, byte[] replyData);

/** 
 Returns the names of the interfaces, specific ones last. The
 functions gets reimplemented by the IDL compiler. If you don't
 use the IDL compiler, consider implementing this function
 manually if you want your object to be easily explorable.

*/
	public native ArrayList interfaces();

/** 
 Returns the list of functions understood by the object. It gets
 reimplemented by the IDL compiler. If you don't use the IDL
 compiler, consider implementing this function manually if you
 want your object to be easily scriptable.

 Rationale: functions() allows an interpreter to do client-side
 type-casting properly.

 Note to implementators: remember to call the baseclasses
 implementation.

*/
	public native ArrayList functions();

/** 
 Emit <code>signal</code> as DCOP signal from this object with <code>data</code> as
 arguments
   
*/
	public native void emitDCOPSignal( String signal, byte[] data);

/** 
 Connect to a DCOP signal

*/
	public native boolean connectDCOPSignal( String sender, String senderObj, String signal, String slot, boolean Volatile);

/** 
 Disconnect a DCOP signal

 A special case is when both sender & signal are empty. In this
 case all connections related to this object in the current client
 are disconnected. (Both connections from as well as to this object!)

*/
	public native boolean disconnectDCOPSignal( String sender, String senderObj, String signal, String slot);

/** 

 {@link DCOPObjectProxy}
   
*/
	public static native boolean hasObject( String objId);

/** 

 This function does not query the {@link DCOPObjectProxy}.
   
*/
	public static native DCOPObjectInterface find( String objId);

/** 
 Creates an object id for the QObject <code>obj.</code> This is done
 using the {@link QObject#name} function.
   
*/
	public static native String objectName( QObject obj);
}
