/***************************************************************************
                            KAboutApplication.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class provides the standard "About Application" dialog box that
 is used by {@link KHelpMenu}. It uses the information of the global
 {@link KAboutData} that is specified at the start of you program in
 main(). Normally you should not use this class directly but
 rather the {@link KHelpMenu} class or even better just subclass your
 toplevel window from {@link KMainWindow}. If you do the latter, the help
 menu and thereby this dialog box is available through the
 {@link KMainWindow#helpMenu} function.

 @author Waldo Bastian (bastian@kde.org) and Espen Sand (espen@kde.org)

 @version $Id
 
 @short Standard "About Application" dialog box.

*/
public class KAboutApplication extends KAboutDialog  {
	protected KAboutApplication(Class dummy){super((Class) null);}


/** 
 Constructor. Creates a fully featured "About Application" dialog box.
 Note that this dialog is made modeless in the {@link KHelpMenu} class so
 the users may expect a modeless dialog.

*/
	private native void newKAboutApplication( QWidget parent, String name, boolean modal);
	public KAboutApplication( QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKAboutApplication( parent, name, modal);
	}
	private native void newKAboutApplication();
	public KAboutApplication() {
		super((Class) null);
		newKAboutApplication();
	}

/** 
 Constructor. Mostly does the same stuff as the above constructor, except
 that it can take a custom KAboutData object instead of the one specified
 in your main() function. This is especially useful for applications
 which are implemented as (dynamically loaded) libraries, e.g. panel
 applets.

*/
	private native void newKAboutApplication( KAboutData aboutData, QWidget parent, String name, boolean modal);
	public KAboutApplication( KAboutData aboutData, QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKAboutApplication( aboutData, parent, name, modal);
	}
	private native void newKAboutApplication( KAboutData aboutData);
	public KAboutApplication( KAboutData aboutData) {
		super((Class) null);
		newKAboutApplication( aboutData);
	}
	protected native void buildDialog( KAboutData aboutData);
}

/** Override these methods in subclasses of KAboutApplication to customise event handling behaviour */
interface KAboutApplicationEventHandling {
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
	void keyPressEvent(QKeyEvent e);
	void keyReleaseEvent(QKeyEvent arg1);
	void dropEvent(QDropEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void showEvent(QShowEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);

/** 
 Emits the {@link hidden} signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
	void hideEvent(QHideEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);

/** 
 Detects when a dialog is being closed from the window manager 
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard {@link QDialog} behavior 
 will take place.
     
*/
	void closeEvent(QCloseEvent e);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

