/***************************************************************************
                            KAction.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KAction class (and derived and super classes) provides a way to
 easily encapsulate a "real" user-selected action or event in your
 program.

 For instance, a user may want to <code>paste</code> the contents of
 the clipboard or <code>scroll</code> <code>down</code> a document or <code>quit</code> the
 application.  These are all <code>actions</code> -- events that the
 user causes to happen.  The KAction class allows the developer to
 deal with these actions in an easy and intuitive manner.

 Specifically, the KAction class encapsulated the various attributes
 to an event/action.  For instance, an action might have an icon
 that goes along with it (a clipboard for a "paste" action or
 scissors for a "cut" action).  The action might have some text to
 describe the action.  It will certainly have a method or function
 that actually <code>executes</code> the action!  All these attributes
 are contained within the KAction object.

 The advantage of dealing with Actions is that you can manipulate
 the Action without regard to the GUI representation of it.  For
 instance, in the "normal" way of dealing with actions like "cut",
 you would manually insert a item for Cut into a menu and a button
 into a toolbar.  If you want to disable the cut action for a moment
 (maybe nothing is selected), you woud have to hunt down the pointer
 to the menu item and the toolbar button and disable both
 individually.  Setting the menu item and toolbar item up uses very
 similar code - but has to be done twice!

 With the Action concept, you simply "plug" the Action into whatever
 GUI element you want.  The KAction class will then take care of
 correctly defining the menu item (with icons, accelerators, text,
 etc) or toolbar button.. or whatever.  From then on, if you
 manipulate the Action at all, the effect will propogate through all
 GUI representations of it.  Back to the "cut" example: if you want
 to disable the Cut Action, you would simply do
 'cutAction.setEnabled(false)' and the menuitem and button would
 instantly be disabled!

 This is the biggest advantage to the Action concept -- there is a
 one-to-one relationship between the "real" action and <code>all</code>
 GUI representations of it.

 The steps to using actions are roughly as follows

 Here is an example of enabling a "New [document]" action
 <PRE>
 KAction newAct = new KAction(i18n("&New"), "filenew",
                               KStdAccel.key(KStdAccel.New), this,
                               SLOT("fileNew()"), this);
 </PRE>
 This line creates our action.  It says that wherever this action is
 displayed, it will use "&New" as the text, the standard icon, and
 the standard accelerator.  It further says that whenever this action
 is invoked, it will use the fileNew() slot to execute it.

 <PRE>
 QPopupMenu file = new QPopupMenu;
 newAct.plug(file);
 </PRE>
 That just inserted the action into the File menu.  The point is, it's not
 important in which menu it is: all manipulation of the item is
 done through the newAct object.

 <PRE>
 newAct.plug(toolBar());
 </PRE>
 And this inserted the Action into the main toolbar as a button.

 That's it!

 If you want to disable that action sometime later, you can do so
 with
 <PRE>
 newAct.setEnabled(false)
 </PRE>
 and both the menuitem in File and the toolbar button will instantly
 be disabled.

 Note: if you are using a "standard" action like "new", "paste",
 "quit", or any other action described in the KDE UI Standards,
 please use the methods in the {@link KStdAction} class rather then
 defining your own.

 If you are using KAction within the context of the XML menu and
 toolbar building framework, then there are a few tiny changes.  The
 first is that you must insert your new action into an action
 collection.  The action collection (a {@link KActionCollection}) is,
 logically enough, a central collection of all of the actions
 defined in your application.  The XML UI framework code in KXMLGUI
 classes needs access to this collection in order to build up the
 GUI (it's how the builder code knows which actions are valid and
 which aren't).

 Inserting your action into the collection is very simple.  To use a
 previous example:

 <pre>
 KAction newAct = new KAction(i18n("&New"), "filenew",
                               KStdAccel.key(KStdAccel.New), this,
                               SLOT("fileNew()"), actionCollection());
 </pre>

 The only change is to use 'actionCollection()' as the parent of the
 action.  That's it!

 Also, if you use the XML builder framework, then you do not ever
 have to plug your actions into containers manually.  The framework
 does that for you.

 @short Class to encapsulate user-driven action or event.
*/
public class KAction extends QObject  {
	protected KAction(Class dummy){super((Class) null);}


/** 
 Construct an action with text and potential keyboard
 accelerator but nothing else.  Use this only if you really
 know what you are doing.

*/
	private native void newKAction( String text, int accel, QObject parent, String name);
	public KAction( String text, int accel, QObject parent, String name) {
		super((Class) null);
		newKAction( text, accel, parent, name);
	}
	private native void newKAction( String text);
	public KAction( String text) {
		super((Class) null);
		newKAction( text);
	}

/** 
 Construct an action with text, potential keyboard
 accelerator, and a SLOT to call when this action is invoked by
 the user.

 If you do not want or have a keyboard accelerator,
 set the <code>accel</code> param to 0.

 This is the most common KAction used when you do not have a
 corresponding icon (note that it won't appear in the current version
 of the "Edit ToolBar" dialog, because an action needs an icon to be
 plugged in a toolbar...).

*/
	private native void newKAction( String text, int accel, QObject receiver, String slot, QObject parent, String name);
	public KAction( String text, int accel, QObject receiver, String slot, QObject parent, String name) {
		super((Class) null);
		newKAction( text, accel, receiver, slot, parent, name);
	}
	private native void newKAction( String text, int accel, QObject receiver, String slot, QObject parent);
	public KAction( String text, int accel, QObject receiver, String slot, QObject parent) {
		super((Class) null);
		newKAction( text, accel, receiver, slot, parent);
	}

/** 
 Construct an action with text, icon, and a potential keyboard
 accelerator.

 This Action cannot execute any command.  Use this only if you
 really know what you are doing.

*/
	private native void newKAction( String text, QIconSet pix, int accel, QObject parent, String name);
	public KAction( String text, QIconSet pix, int accel, QObject parent, String name) {
		super((Class) null);
		newKAction( text, pix, accel, parent, name);
	}
	private native void newKAction( String text, QIconSet pix);
	public KAction( String text, QIconSet pix) {
		super((Class) null);
		newKAction( text, pix);
	}

/** 
 Construct an action with text, automatically loaded icon, and a
 potential keyboard accelerator.

 This Action cannot execute any command.  Use this only if you
 really know what you are doing.

*/
	private native void newKAction( String text, String pix, int accel, QObject parent, String name);
	public KAction( String text, String pix, int accel, QObject parent, String name) {
		super((Class) null);
		newKAction( text, pix, accel, parent, name);
	}
	private native void newKAction( String text, String pix);
	public KAction( String text, String pix) {
		super((Class) null);
		newKAction( text, pix);
	}

/** 
 Construct an action with text, icon, potential keyboard
 accelerator, and a SLOT to call when this action is invoked by
 the user.

 If you do not want or have a keyboard accelerator, set the
 <code>accel</code> param to 0.

 This is the other common KAction used.  Use it when you
 <code>do</code> have a corresponding icon.

*/
	private native void newKAction( String text, QIconSet pix, int accel, QObject receiver, String slot, QObject parent, String name);
	public KAction( String text, QIconSet pix, int accel, QObject receiver, String slot, QObject parent, String name) {
		super((Class) null);
		newKAction( text, pix, accel, receiver, slot, parent, name);
	}
	private native void newKAction( String text, QIconSet pix, int accel, QObject receiver, String slot, QObject parent);
	public KAction( String text, QIconSet pix, int accel, QObject receiver, String slot, QObject parent) {
		super((Class) null);
		newKAction( text, pix, accel, receiver, slot, parent);
	}

/** 
 Construct an action with text, icon, potential keyboard
 accelerator, and a SLOT to call when this action is invoked by
 the user.  The icon is loaded on demand later based on where it
 is plugged in.

 If you do not want or have a keyboard accelerator, set the
 <code>accel</code> param to 0.

 This is the other common KAction used.  Use it when you
 <code>do</code> have a corresponding icon.

*/
	private native void newKAction( String text, String pix, int accel, QObject receiver, String slot, QObject parent, String name);
	public KAction( String text, String pix, int accel, QObject receiver, String slot, QObject parent, String name) {
		super((Class) null);
		newKAction( text, pix, accel, receiver, slot, parent, name);
	}
	private native void newKAction( String text, String pix, int accel, QObject receiver, String slot, QObject parent);
	public KAction( String text, String pix, int accel, QObject receiver, String slot, QObject parent) {
		super((Class) null);
		newKAction( text, pix, accel, receiver, slot, parent);
	}

/** 
 Construct a null action.
 This is not recommended since all actions should have a text,
 for the "Edit ToolBar" dialog. So don't forget to call setText later :)

*/
	private native void newKAction( QObject parent, String name);
	public KAction( QObject parent, String name) {
		super((Class) null);
		newKAction( parent, name);
	}
	private native void newKAction();
	public KAction() {
		super((Class) null);
		newKAction();
	}

/** 
 Standard destructor
     
*/
	protected native void finalize() throws InternalError;

/** 
 "Plug" or insert this action into a given widget.

 This will
 typically be a menu or a toolbar.  From this point on, you will
 never need to directly manipulate the item in the menu or
 toolbar.  You do all enabling/disabling/manipulation directly
 with your KAction object.

*/
	public native int plug( QWidget w, int index);
	public native int plug( QWidget w);

/** 
 "Plug" or insert this action into a given KAccel.

 It is sometimes useful to use the action paradigm for
 actions that are not associated with some widget (ie actions
 that are only activated by keyboard).

*/
	public native void plugAccel( KAccel accel, boolean configurable);
	public native void plugAccel( KAccel accel);

/** 
 "Unplug" or remove this action from a given widget.

 This will typically be a menu or a toolbar.  This is rarely
 used in "normal" application.  Typically, it would be used if
 your application has several views or modes, each with a
 completely different menu structure.  If you simply want to
 disable an action for a given period, use {@link #setEnabled}
 instead.

*/
	public native void unplug( QWidget w);

/** 
 Disconnect this action from the KAccel.
     
*/
	public native void unplugAccel();

/** 
 returns whether the action is plugged into any container widget or not.
     
*/
	public native boolean isPlugged();

/** 
 returns whether the action is plugged into the given container with the given, container specific, id (often
 menu or toolbar id ) .
     
*/
	public native boolean isPlugged( QWidget container, int identifier);

/** 
 returns whether the action is plugged into the given container with the given, container specific, representative
 container widget item.
     
*/
	public native boolean isPlugged( QWidget container, QWidget _representative);
	public native QWidget container( int index);
	public native int itemId( int index);
	public native QWidget representative( int index);
	public native int containerCount();
	public native QPixmap pixmap();
	public native boolean hasIconSet();
	public native String plainText();

/** 
 Get the text associated with this action.
     
*/
	public native String text();

/** 
 Get the keyboard accelerator associated with this action.
     
*/
	public native int accel();

/**  Returns true if this action is enabled. 
*/
	public native boolean isEnabled();
	public native String group();

/** 
 Get the What's this text for the action.
     
*/
	public native String whatsThis();

/** 
 Get the tooltip text for the action.
     
*/
	public native String toolTip();
	public native String statusText();

/** 
 Get the QIconSet from which the icons used to display this action will
 be chosen.
     
*/
	public native QIconSet iconSet();
	public native String icon();
	public native KActionCollection parentCollection();
	public native void unplugAll();

/** 
 Set the text associated with this action. The text is used for menu
 and toolbar labels etc.
     
*/
	public native void setText( String text);

/** 
 Set the keyboard accelerator associated with this action.
     
*/
	public native void setAccel( int a);
	public native void setGroup( String arg1);

/** 
 Set the What's this text for the action. This text will be displayed when
 a widget that has been created by plugging this action into a container
 is clicked on in What's this mode.

 The What's this text can include QML markup as well as raw text.
     
*/
	public native void setWhatsThis( String text);

/** 
 Set the tooltip text for the action.
 This will be used as a tooltip for a toolbar button, as a
 statusbar help-text for a menu item, and it also appears
 in the toolbar editor, to describe the action.
     
*/
	public native void setToolTip( String arg1);

/** 
 Set the QIconSet from which the icons used to display this action will
 be chosen.
     
*/
	public native void setIconSet( QIconSet iconSet);
	public native void setIcon( String icon);

/** 

     
*/
	public native void setStatusText( String text);

/** 
 Enables or disables this action. All uses of this action (eg. in menus
 or toolbars) will be updated to reflect the state of the action.
     
*/
	public native void setEnabled( boolean enable);

/** 
 Emulate user's interaction programmatically, by activating the action.
 The implementation simply emits activated().
     
*/
	public native void activate();

/** 

 Generate a toolbar button id. Made public for reimplementations.
     
*/
	public static native int getToolButtonID();
	protected native KToolBar toolBar( int index);
	protected native QPopupMenu popupMenu( int index);
	protected native void removeContainer( int index);
	protected native int findContainer( QWidget widget);
	protected native void addContainer( QWidget parent, int identifier);
	protected native void addContainer( QWidget parent, QWidget representative);
	protected native void setAccel( int identifier, int accel);
	protected native void setGroup( int identifier, String grp);
	protected native void setText( int i, String text);
	protected native void setEnabled( int i, boolean enable);
	protected native void setIconSet( int i, QIconSet iconSet);
	protected native void setIcon( int i, String icon);
	protected native void setToolTip( int identifier, String tt);
	protected native void setStatusText( int identifier, String text);
	protected native void setWhatsThis( int identifier, String text);

/** 
 for backwards compatibility. deprecated!
       
*/
	protected native int menuId( int i);
	protected native void slotDestroyed();
	protected native void slotKeycodeChanged();
	protected native void slotActivated();
}

/** Override these methods in subclasses of KAction to customise event handling behaviour */
interface KActionEventHandling {
	void childEvent(QChildEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

