/***************************************************************************
                            KColorDialog.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 
 The KColorDialog provides a dialog for color selection.

 In most cases, you will want to use the static method {@link KColorDialog#getColor}.
 This pops up the dialog (with an initial selection provided by you), lets the
 user choose a color, and returns.

 Example:

 <pre>
 	QColor myColor;
 	int result = KColorDialog.getColor( myColor );
         if ( result == KColorDialog.Accepted )
            ...
 </pre>

 The color dialog is really a collection of several widgets which can
 you can also use separately: the quadratic plane in the top left of
 the dialog is a {@link KXYSelector}. Right next to it is a {@link KHSSelector}
 for chosing hue/saturation.

 On the right side of the dialog you see a {@link KPaletteTable} showing
 up to 40 colors with a combo box which offers several predefined
 palettes or a palette configured by the user. The small field showing
 the currently selected color is a {@link KColorPatch}.

 @short A color selection dialog.

*/
public class KColorDialog extends KDialogBase  {
	protected KColorDialog(Class dummy){super((Class) null);}


/**  
 Construct a {@link KColorDialog}.
     
*/
	private native void newKColorDialog( QWidget parent, String name, boolean modal);
	public KColorDialog( QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKColorDialog( parent, name, modal);
	}
	private native void newKColorDialog();
	public KColorDialog() {
		super((Class) null);
		newKColorDialog();
	}
	protected native void finalize() throws InternalError;

/**  
 Retrieve the currently selected color. 

*/
	public native QColor color();

/**  
 Preselects a color.
     
*/
	public native void setColor( QColor col);

/** 
 Create a modal color dialog, let the user choose a
 color, and return when the dialog is closed.

 The selected color is returned in the argument <code>theColor.</code>

*/
	public static native int getColor( QColor theColor, QWidget parent);
	public static native int getColor( QColor theColor);

/** 
 Get the color from the pixel at point p on the screen.
     
*/
	public static native QColor grabColor( QPoint p);
}

/** Override these methods in subclasses of KColorDialog to customise event handling behaviour */
interface KColorDialogEventHandling {

/** 

    
*/
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);

/** 

    
*/
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);

/** 
 Emits the {@link hidden} signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
	void hideEvent(QHideEvent arg1);

/** 
 Detects when a dialog is being closed from the window manager 
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard {@link QDialog} behavior 
 will take place.
     
*/
	void closeEvent(QCloseEvent e);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

