/***************************************************************************
                            KConfigGroupSaver.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Helper class to facilitate working with {@link KConfig} / {@link KSimpleConfig}
 groups.

 Careful programmers always set the group of a
 {@link KConfig} {@link KSimpleConfig} object to the group they want to read from
 and set it back to the old one of afterwards. This is usually
 written as:
 <pre>

 String oldgroup config.group();
 config.setGroup( "TheGroupThatIWant" );
 ...
 config.writeEntry( "Blah", "Blubb" );

 config.setGroup( oldgroup );
 </pre>

 In order to facilitate this task, you can use
 KConfigGroupSaver. Simply construct such an object ON THE STACK
 when you want to switch to a new group. Then, when the object goes
 out of scope, the group will automatically be restored. If you
 want to use several different groups within a function or method,
 you can still use KConfigGroupSaver: Simply enclose all work with
 one group (including the creation of the KConfigGroupSaver object)
 in one block.

 @author Matthias Kalle Dalheimer <kalle@kde.org>

 @version $Id: KConfigGroupSaver.java,v 1.2 2001/05/07 01:30:47 rdale Exp $

 @short Helper class for easier use of KConfig/KSimpleConfig groups.
*/
public class  KConfigGroupSaver implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KConfigGroupSaver(Class dummy){}

	protected native void finalize() throws InternalError;
	public native KConfigBase config();
}
