/***************************************************************************
                            KFileDialog.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Abstract baseclass for all preview widgets which shall be used via
 KFileDialog.setPreviewWidget(const KPreviewWidgetBase ).

 Just derive your custom preview widget from KPreviewWidgetBase and overload
 all methods, especially the slot showPreview(const KURL &) which is called
 every time the file selection changes.

 @author Frerich Raabe <raabe@kde.org>
 
 @short Abstract baseclass for all preview widgets.

*/
public class KFileDialog extends KDialogBase  {
	protected KFileDialog(Class dummy){super((Class) null);}


/** 
 Construct a file dialog.

*/
	private native void newKFileDialog( String startDir, String filter, QWidget parent, String name, boolean modal);
	public KFileDialog( String startDir, String filter, QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKFileDialog( startDir, filter, parent, name, modal);
	}

/** 
 Destruct the file dialog.
     
*/
	protected native void finalize() throws InternalError;

/** 

*/
	public native KURL selectedURL();

/** 

*/
	public native ArrayList selectedURLs();

/** 

*/
	public native KURL baseURL();

/** 
 Retrieve the full path of the selected file in the local filesystem.
 (Local files only)
     
*/
	public native String selectedFile();

/** 
 Retrieve a list of all selected local files.
     
*/
	public native ArrayList selectedFiles();

/** 
 Set the directory to view.

*/
	public native void setURL( KURL url, boolean clearforward);
	public native void setURL( KURL url);

/** 
 Set the file name to preselect to <code>name</code>

 This takes absolute URLs and relative file names.
     
*/
	public native void setSelection( String name);

/** 
 Sets whether the filename/url should be kept when changing directories.
 This is for example useful when having a predefined filename where
 the full path for that file is searched.

 getSaveFileName() and getSaveURL() set this to true by default, so that
 you can type in the filename and change the directory without having
 to type the name again.
     
*/
	public native void setKeepLocation( boolean keep);

/** 

*/
	public native boolean keepsLocation();

/** 
 Set the filter to be used to <code>filter.</code>

 You can set more
 filters for the user to select seperated by '\n'. Every
 filter entry is defined through namefilter|text to diplay.
 If no | is found in the expression, just the namefilter is
 shown. Examples:

 <pre>
 kfile.setFilter(".cpp|C++ Source Files\n.h|Header files");
 kfile.setFilter(".cpp");
 kfile.setFilter(".cpp|Sources (.cpp)");
 kfile.setFilter(".cpp .cc .C|C++ Source Files\n.h .H|Header files");
 </pre>

 Note: The text to display is not parsed in any way. So, if you
 want to show the suffix to select by a specific filter, you must
 repeat it.

 If the filter contains a '/', a mimetype-filter is assumed. You can 
 specify multiple mimetypes like this (separated with space):

 <pre>
 kfile.setFilter( "image/png text/html text/plain" );
 </pre>

*/
	public native void setFilter( String filter);

/** 
 Retrieve the current filter as entered by the user or one of the
 predefined set via {@link #setFilter}.

*/
	public native String currentFilter();

/** 
 Set the filter up to specify the output type.

 Do not use in conjunction with {@link #setFilter}

     
*/
//	public native void setFilterMimeType( String label, KMimeType_List types, KMimeType_Ptr defaultType);

/** 
 The mimetype for the desired output format.

 This is only valid if {@link #setFilterMimeType} has been called
 previously.

*/
//	public native KMimeType_Ptr currentFilterMimeType();

/** 
 Set the filter up to specify the output type.

 Do not use in conjunction with {@link #setFilter}
     
*/
	public native void setMimeFilter( String[] types, String defaultType);
	public native void setMimeFilter( String[] types);

/** 
 The mimetype for the desired output format.

 This is only valid if {@link #setMimeFilter} has been called
 previously.

*/
	public native String currentMimeFilter();

/** 
  Clears any mime- or namefilter. Does not reload the directory.
     
*/
	public native void clearFilter();

/** 

 Add a preview widget and enter the preview mode.

 In this mode
 the dialog is split and the right part contains your widget.
 This widget has to inherit {@link QWidget} and it has to implement
 a slot {@link #showPreview}; which is called
 every time the file changes. You may want to look at
 koffice/lib/kofficecore/koFilterManager.cc for some hints :)
     
*/
	public native void setPreviewWidget( QWidget w);

/** 
 Add a preview widget and enter the preview mode.

 In this mode the dialog is split and the right part contains your
 preview widget.

*/
//	public native void setPreviewWidget( KPreviewWidgetBase* w);

/** 

     
*/
	public native void setMode( int m);

/** 
 Set the mode of the dialog.

 The mode is defined as (in kfile.h):
 <pre>    enum Mode {
                      File         = 1,
                      Directory    = 2,
                      Files        = 4,
                      ExistingOnly = 8,
                      LocalOnly    = 16
                    };
 </pre>
 You can OR the values, e.g.
 <pre>
 KFile.Mode mode = static_cast<KFile.Mode>( KFile.Files |
                                              KFile.ExistingOnly |
                                              KFile.LocalOnly );
 setMode( mode );
 </pre>
     
*/
//	public native void setMode( int m);

/** 
 Retrieve the mode of the filedialog.

*/
	public native int mode();

/** 
 Set the text to be displayed in front of the
 selection.

 The default is "Location".
 Most useful if you want to make clear what
 the location is used for.
     
*/
	public native void setLocationLabel( String text);

/** 
 Retrieve a pointer to the toolbar.

 You can use this to insert custom
 items into it, e.g.:
 <pre>
      yourAction = new KAction( i18n("Your Action"), 0,
                                this, SLOT(" yourSlot()"),
                                this, "action name" );
      yourAction.plug( kfileDialog.toolBar() );
 </pre>
     
*/
	public native KToolBar toolBar();

/** 

*/
	public native QPushButton okButton();

/** 

*/
	public native QPushButton cancelButton();

/** 
 Create a modal file dialog and return the selected
 filename or an empty string if none was chosen.

 Note that with
 this method the user must select an existing filename.

*/
	public static native String getOpenFileName( String startDir, String filter, QWidget parent, String caption);

/** 
 Create a modal file dialog and return the selected
 filenames or an empty list if none was chosen.

 Note that with
 this method the user must select an existing filename.

*/
	public static native ArrayList getOpenFileNames( String startDir, String filter, QWidget parent, String caption);

/** 
 Create a modal file dialog and return the selected
 URL or an empty string if none was chosen.

 Note that with
 this method the user must select an existing URL.

*/
	public static native KURL getOpenURL( String startDir, String filter, QWidget parent, String caption);
	public static native KURL getOpenURL();

/** 
 Create a modal file dialog and return the selected
 URLs or an empty list if none was chosen.

 Note that with
 this method the user must select an existing filename.

*/
	public static native ArrayList getOpenURLs( String startDir, String filter, QWidget parent, String caption);

/** 
 Create a modal file dialog and return the selected
 filename or an empty string if none was chosen.

 Note that with this
 method the user need not select an existing filename.

*/
	public static native String getSaveFileName( String startDir, String filter, QWidget parent, String caption);

/** 
 Create a modal file dialog and returns the selected
 filename or an empty string if none was chosen.

 Note that with this
 method the user need not select an existing filename.

*/
	public static native KURL getSaveURL( String startDir, String filter, QWidget parent, String caption);
	public static native KURL getSaveURL();

/** 
 Create a modal file dialog and returns the selected
 directory or an empty string if none was chosen.

 Note that with this
 method the user need not select an existing directory.

*/
	public static native String getExistingDirectory( String startDir, QWidget parent, String caption);

/** 
 Create a modal file dialog with an image previewer and returns the
 selected url or an empty string if none was chosen.

*/
	public static native KURL getImageOpenURL( String startDir, QWidget parent, String caption);
	public static native KURL getImageOpenURL();

/** 
 adds a entry of the current directory. If disableUpdating is set
 to true, it will care about clever updating

*/
	protected native void addDirEntry( KFileViewItem entry, boolean disableUpdating);

/** 
 rebuild geometry managment.

      
*/
	protected native void initGUI();

/** 
 called when an item is highlighted/selected in multiselection mode.
 handles setting the locationEdit.
     
*/
	protected native void multiSelectionChanged();

/** 
 Reads configuration and applies it (size, recent directories, ...)
     
*/
	protected native void readConfig( KConfig arg1, String group);
	protected native void readConfig( KConfig arg1);

/** 
 Saves the current configuration
     
*/
	protected native void saveConfig( KConfig arg1, String group);
	protected native void saveConfig( KConfig arg1);

/** 
 Reads the recent used files and inserts them into the location combobox
     
*/
	protected native void readRecentFiles( KConfig arg1);

/** 
 Saves the entries from the location combobox.
     
*/
	protected native void saveRecentFiles( KConfig arg1);

/** 
 Parses the string "line" for files. If line doesn't contain any ", the
 whole line will be interpreted as one file. If the number of " is odd,
 an empty list will be returned. Otherwise, all items enclosed in " "
 will be returned as correct urls.
     
*/
	protected native ArrayList tokenize( String line);
	protected native ArrayList parseSelectedURLs();
	protected native void urlEntered( KURL arg1);
	protected native void pathComboActivated( KURL url);
	protected native void pathComboReturnPressed( String url);
	protected native void locationActivated( String url);
	protected native void toolbarCallback( int arg1);
	protected native void toolbarPressedCallback( int arg1);
	protected native void slotFilterChanged();
	protected native void pathComboChanged( String arg1);
	protected native void fileHighlighted( KFileViewItem i);
	protected native void fileSelected( KFileViewItem i);
	protected native void slotStatResult( Job job);
	protected native void slotLoadingFinished();
	protected native void dirCompletion( String arg1);
	protected native void fileCompletion( String arg1);
	protected native void updateStatusLine( int dirs, int files);
	protected native void slotOk();
	protected native void accept();
	protected native void slotCancel();

/** 
 Add the current location to the global bookmarks list
      
*/
	protected native void addToBookmarks();
	protected native void bookmarksChanged();
	protected native void fillBookmarkMenu( KFileBookmark parent, QPopupMenu menu, int identifier);
}

/** Override these methods in subclasses of KFileDialog to customise event handling behaviour */
interface KFileDialogEventHandling {

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
	void keyPressEvent(QKeyEvent e);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);

/** 
 Emits the {@link hidden} signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
	void hideEvent(QHideEvent arg1);

/** 
 Detects when a dialog is being closed from the window manager 
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard {@link QDialog} behavior 
 will take place.
     
*/
	void closeEvent(QCloseEvent e);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

